/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.common.worldgen.structure.SimpleTemplatePiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.natural.CloudBlock;
import org.confluence.mod.common.block.natural.EvaporativeCloudBlock;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.joml.Vector3d;

public class HeavenIslandsStructure
extends Structure {
    public static final MapCodec<HeavenIslandsStructure> CODEC = HeavenIslandsStructure.simpleCodec(HeavenIslandsStructure::new);
    private static final String[] sideMap = new String[]{"heaven_islands/sky_island_house_side_0", "heaven_islands/sky_island_house_side_1"};
    private static final ResourceLocation[] feature = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"patch_grass"), ResourceLocation.withDefaultNamespace((String)"patch_tall_grass"), ResourceLocation.withDefaultNamespace((String)"flower_flower_forest")};
    private static final ResourceLocation[] featureTree = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"oak"), ResourceLocation.withDefaultNamespace((String)"cherry"), Confluence.asResource("yellow_willow")};

    protected HeavenIslandsStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int z;
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        if (x * x + (z = startChunk.getMiddleBlockZ()) * z <= 40000) {
            return Optional.empty();
        }
        return HeavenIslandsStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            WorldgenRandom random = context.random();
            BlockPos centerPos = new BlockPos(x, random.nextInt(260, 280), z);
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            HashMap featureMap = new HashMap();
            int height = 2;
            int type = random.nextInt(2);
            int typeSide0 = random.nextInt(2);
            int typeSide1 = random.nextInt(2);
            int houseFace0 = random.nextInt(2);
            int houseFace1 = random.nextInt(2);
            int radiusXZ = random.nextInt(24, 30);
            int radiusY = random.nextInt(16, 20);
            int rotateFace = random.nextInt(2) == 1 ? 1 : -1;
            int rotateCount = random.nextInt(5, 7);
            float rotateStart = (float)Math.PI * 2 * random.nextFloat();
            float rotateStepFirst = (float)Math.PI * 2 / (float)rotateCount;
            float rotateStep = (0.12f + 0.05f * random.nextFloat()) * (float)rotateFace;
            LinkedList vctPosList = new LinkedList();
            if (type == 0) {
                StructureUtils.ellipsoid((double)(radiusXZ - 4), (double)(radiusY - 2), (double)(radiusXZ - 4), (BlockPos)centerPos, (int)0, (int)3, (boolean)true, (Object2IntMap)blockMap, (int)(centerPos.getY() - 2));
                StructureUtils.lineSetEllipsoid((List)VectorUtils.ellipsoidPos((double)((double)radiusXZ / 2.0), (double)1.99, (double)((double)radiusXZ / 2.0), (BlockPos)centerPos, (float)0.2f, (WorldgenRandom)random), (double)((double)radiusXZ / 2.0 - 3.0), (double)1.9, (double)((double)radiusXZ / 2.0 - 3.0), (int)4, (boolean)true, (Object2IntMap)blockMap);
                VectorUtils.roundPos((BlockPos)centerPos.offset(0, 3, 0), (double)((double)radiusXZ / 2.0 + 2.0), (WorldgenRandom)random, vctPosList, (int)7, (int)32, (float)0.0f);
                StructureUtils.lineSetFeature(vctPosList, featureMap, (ResourceLocation[])feature, (WorldgenRandom)random);
                vctPosList.clear();
                VectorUtils.roundPos((BlockPos)centerPos.offset(0, 3, 0), (double)((double)radiusXZ / 2.0 + 5.0), (WorldgenRandom)random, vctPosList, (int)1, (int)4, (float)0.7853981f);
                StructureUtils.lineSetFeature(vctPosList, featureMap, (ResourceLocation[])featureTree, (WorldgenRandom)random);
                StructureUtils.rectangular((BlockPos)centerPos.offset(-7, 2, -5), (BlockPos)centerPos.offset(7, 2, 5), (int)3, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)centerPos.offset(-5, 2, -7), (BlockPos)centerPos.offset(5, 2, 7), (int)3, (Object2IntMap)blockMap, (int)0);
                if (houseFace0 == 0) {
                    if (typeSide0 == 0) {
                        StructureUtils.rectangular((BlockPos)centerPos.offset(-16, 2, -3), (BlockPos)centerPos.offset(-8, 2, 3), (int)3, (Object2IntMap)blockMap, (int)0);
                    }
                    if (typeSide1 == 0) {
                        StructureUtils.rectangular((BlockPos)centerPos.offset(8, 2, -3), (BlockPos)centerPos.offset(16, 2, 3), (int)3, (Object2IntMap)blockMap, (int)0);
                    }
                } else {
                    if (typeSide0 == 0) {
                        StructureUtils.rectangular((BlockPos)centerPos.offset(-3, 2, -16), (BlockPos)centerPos.offset(3, 2, -8), (int)3, (Object2IntMap)blockMap, (int)0);
                    }
                    if (typeSide1 == 0) {
                        StructureUtils.rectangular((BlockPos)centerPos.offset(-3, 2, 8), (BlockPos)centerPos.offset(3, 2, 16), (int)3, (Object2IntMap)blockMap, (int)0);
                    }
                }
            } else {
                StructureUtils.ellipsoid((double)(radiusXZ - 4), (double)(radiusY - 2), (double)(radiusXZ - 4), (BlockPos)centerPos, (int)0, (int)2, (boolean)true, (Object2IntMap)blockMap, (int)centerPos.getY());
            }
            List cloudPos = VectorUtils.ellipsoidPos((double)(radiusXZ - 5), (double)(radiusY - 3), (double)(radiusXZ - 5), (double)radiusXZ, (double)radiusY, (double)radiusXZ, (BlockPos)centerPos, (float)0.4f, (WorldgenRandom)random, (int)centerPos.getY());
            StructureUtils.lineSet((List)cloudPos, (double)3.2, (double)3.2, (int)1, (boolean)true, (Object2IntMap)blockMap);
            for (int i = 0; i < rotateCount; ++i) {
                double radiusCloud = 3.0 + 2.0 * random.nextDouble();
                StructureUtils.lineSet((List)VectorUtils.rotateCloudPos((float)(rotateStart + (float)i * rotateStepFirst), (float)rotateStep, (double)radiusXZ, (double)((double)radiusXZ / 20.0), (int)random.nextInt(10, 16), (BlockPos)centerPos), (double)radiusCloud, (double)0.0, (int)1, (boolean)true, (Object2IntMap)blockMap);
                StructureUtils.lineSet((List)VectorUtils.rotateCloudPos((float)(rotateStart + (float)i * rotateStepFirst), (float)(-rotateStep), (double)radiusXZ, (double)((double)radiusXZ / -15.0), (int)random.nextInt(10, 14), (BlockPos)centerPos), (double)radiusCloud, (double)0.0, (int)1, (boolean)true, (Object2IntMap)blockMap);
            }
            vctPosList.clear();
            VectorUtils.roundPos((BlockPos)centerPos.offset(0, 25, 0), (double)((double)radiusXZ / 2.0 + 8.0), (WorldgenRandom)random, vctPosList, (int)5, (int)random.nextInt(2, 7), (float)0.7853981f);
            Iterator iterator = vctPosList.iterator();
            while (iterator.hasNext()) {
                Vector3d vector3d;
                Vector3d littleCloudPos = vector3d = (Vector3d)iterator.next();
                BlockPos littleCloudPosInt = new BlockPos(Mth.floor((double)littleCloudPos.x), Mth.floor((float)((int)littleCloudPos.y + random.nextInt(-5, 6))), Mth.floor((double)littleCloudPos.z));
                radiusXZ = random.nextInt(5, 8);
                radiusY = random.nextInt(3, 6);
                cloudPos.clear();
                StructureUtils.ellipsoid((double)(radiusXZ - 2), (double)(radiusY - 2), (double)(radiusXZ - 2), (BlockPos)littleCloudPosInt.offset(0, 1, 0), (int)6, (int)2, (boolean)true, (Object2IntMap)blockMap, (int)littleCloudPosInt.getY());
                cloudPos = VectorUtils.ellipsoidPos((double)(radiusXZ - 2), (double)(radiusY - 2), (double)(radiusXZ - 2), (double)radiusXZ, (double)radiusY, (double)radiusXZ, (BlockPos)littleCloudPosInt, (float)0.7f, (WorldgenRandom)random, (int)littleCloudPosInt.getY());
                StructureUtils.lineSet((List)cloudPos, (double)1.5, (double)1.5, (int)1, (boolean)true, (Object2IntMap)blockMap);
            }
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), ((CloudBlock)((Object)((Object)NatureBlocks.CLOUD_BLOCK.get()))).defaultBlockState(), Blocks.WATER.defaultBlockState(), Blocks.STONE.defaultBlockState(), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), ((EvaporativeCloudBlock)((Object)((Object)NatureBlocks.EVAPORATIVE_CLOUD_BLOCK.get()))).defaultBlockState()}), featureMap, (StructurePiecesBuilder)builder);
            if (type == 0) {
                if (houseFace0 == 0) {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(context.structureTemplateManager(), "heaven_islands/sky_island_house", centerPos.offset(houseFace1 == 0 ? 6 : -6, height, houseFace1 == 0 ? -12 : 12), false, true, houseFace1 == 0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90));
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(context.structureTemplateManager(), sideMap[typeSide0], centerPos.offset(-7, height, 9), false, true, Rotation.CLOCKWISE_180));
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(context.structureTemplateManager(), sideMap[typeSide1], centerPos.offset(7, height, -9), false, true, Rotation.NONE));
                } else {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(context.structureTemplateManager(), "heaven_islands/sky_island_house", centerPos.offset(houseFace1 == 0 ? 12 : -12, height, houseFace1 == 0 ? 6 : -6), false, true, houseFace1 == 0 ? Rotation.CLOCKWISE_180 : Rotation.NONE));
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(context.structureTemplateManager(), sideMap[typeSide0], centerPos.offset(-9, height, -7), false, true, Rotation.COUNTERCLOCKWISE_90));
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(context.structureTemplateManager(), sideMap[typeSide1], centerPos.offset(9, height, 7), false, true, Rotation.CLOCKWISE_90));
                }
            }
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.HEAVEN_ISLANDS.get();
    }
}

