/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.block.OreBlocks;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class IceThornStructure
extends Structure {
    public static final MapCodec<IceThornStructure> CODEC = IceThornStructure.simpleCodec(IceThornStructure::new);
    public static final ResourceLocation[] feature = new ResourceLocation[]{Confluence.asResource("amber_tree"), Confluence.asResource("diamond_tree"), Confluence.asResource("jade_tree"), Confluence.asResource("ruby_tree"), Confluence.asResource("sapphire_tree"), Confluence.asResource("topaz_tree"), Confluence.asResource("amethyst_tree")};

    protected IceThornStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int z;
        int lowestY = IceThornStructure.getLowestY((Structure.GenerationContext)context, (int)16, (int)16);
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        if (x * x + (z = startChunk.getMiddleBlockZ()) * z <= 160000 || lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return IceThornStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            WorldgenRandom random = context.random();
            BlockPos centerPos = startChunk.getMiddleBlockPosition(lowestY);
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            int count = random.nextInt(4, 7);
            int step = 80 / count;
            Vector3d mainStart = VectorUtils.toVector3d((BlockPos)centerPos);
            Vector3d mainEnd = VectorUtils.toVector3d((BlockPos)centerPos).add(0.0, (double)random.nextInt(120, 150), 0.0);
            ArrayList<Vector3d> otherEnds = new ArrayList<Vector3d>();
            for (int i = 1; i <= count; ++i) {
                double radius = random.nextInt(10, 16);
                Vector3d otherEnd = new Vector3d((double)random.nextInt(-50, 51), (double)(step * i + random.nextInt(-3, 4)), (double)random.nextInt(-50, 51));
                Vector3d endPos = new Vector3d(otherEnd.x + mainStart.x, otherEnd.y + mainStart.y, otherEnd.z + mainStart.z);
                List thorns = VectorUtils.frustumSetPos((Vector3d)mainStart, (Vector3d)endPos, (double)radius, (double)0.6, (float)0.05f, (WorldgenRandom)random);
                for (Vector3d thorn : thorns) {
                    int countThorn = random.nextInt(5, 11);
                    for (int j = 0; j < countThorn; ++j) {
                        blockMap.put((Object)BlockPos.containing((double)thorn.x, (double)(thorn.y - (double)j), (double)thorn.z), 2);
                    }
                }
                StructureUtils.frustumSet((Vector3d)mainStart, (Vector3d)new Vector3d((Vector3dc)endPos), (double)radius, (double)0.6, (int)0, (Object2IntMap)blockMap);
                otherEnds.add(otherEnd);
            }
            StructureUtils.frustumSet((Vector3d)mainStart, (Vector3d)mainEnd, (double)random.nextInt(10, 16), (double)0.6, (int)0, (Object2IntMap)blockMap);
            StructureUtils.frustumSet((Vector3d)mainStart, (Vector3d)mainEnd.set(mainEnd.x, mainStart.y + (double)random.nextInt(10, 15), mainEnd.z), (double)random.nextInt(2, 4), (double)0.6, (int)1, (Object2IntMap)blockMap);
            for (Vector3d end : otherEnds) {
                StructureUtils.frustumSet((Vector3d)mainStart, (Vector3d)new Vector3d(mainStart.x + end.x * 0.1, mainStart.y + end.y * 0.1, mainStart.z + end.z * 0.1), (double)random.nextInt(2, 4), (double)0.6, (int)1, (Object2IntMap)blockMap);
            }
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.PACKED_ICE.defaultBlockState(), ((Block)OreBlocks.WINTER_MARROW_BLOCK.get()).defaultBlockState(), Blocks.ICE.defaultBlockState()}), (StructurePiecesBuilder)builder);
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.ICE_THORN.get();
    }
}

