/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.block.OreBlocks;
import org.confluence.mod.common.worldgen.structure.BaseStructures;

public class LivingMahoganyTreeStructure
extends Structure {
    public static final MapCodec<LivingMahoganyTreeStructure> CODEC = LivingMahoganyTreeStructure.simpleCodec(LivingMahoganyTreeStructure::new);
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIVING_IVY_CHESTS = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "living_ivy_chests");

    protected LivingMahoganyTreeStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int lowestY = StructureUtils.getHeight((int)x, (int)z, (Structure.GenerationContext)context);
        if (x * x + z * z <= 160000 || lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return LivingMahoganyTreeStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            WorldgenRandom random = context.random();
            BlockPos centerPos = startChunk.getMiddleBlockPosition(lowestY);
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            BaseStructures.livingTree(centerPos, (Object2IntMap<BlockPos>)blockMap, random, random.nextInt(36, 42), 1, 2.5, 0.8, 1, 14, 2, -12, 1, 1, 1, 1, 5, 1, 7, 5, -10, 2, 1, 1, 1, 4, 2, true, random.nextInt(36, 40), 0, 0.0, 0.0, 0, false, 9.0, 3.0, 13.0, 4.0, 2.0, 1.0, 0.2f, 0.75f, 2, 3);
            StructureUtils.rectangular((BlockPos)centerPos.offset(1, 0, 1), (BlockPos)centerPos.offset(-1, 1, -1), (int)0, (Object2IntMap)blockMap, (int)0);
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), ((RotatedPillarBlock)NatureBlocks.LIVING_MAHOGANY_LOG_BLOCKS.WOOD.get()).defaultBlockState(), (BlockState)((LeavesBlock)NatureBlocks.LIVING_MAHOGANY_LOG_BLOCKS.LEAVES.get()).defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), ((Block)OreBlocks.SPORE_ROOT_BLOCK.get()).defaultBlockState()}), Map.of(centerPos, LIVING_IVY_CHESTS.location()), (StructurePiecesBuilder)builder);
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.LIVING_MAHOGANY_TREE.get();
    }
}

