/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.common.worldgen.structure.SimpleTemplatePiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.functional.EverPoweredRailBlock;
import org.confluence.mod.common.block.functional.InstantExplosionBlock;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class MineTunnelsStructure
extends Structure {
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAIL_SUPPORT = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "rail_support");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAIL_BOULDER = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "rail_boulder");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAIL_DART = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "rail_dart");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAIL_STONE_BRICKS = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "rail_stone_bricks");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAIL_TUFF_BRICKS = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "rail_tuff_bricks");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAIL_SPRUCE_LOG = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "rail_spruce_log");
    public static final MapCodec<MineTunnelsStructure> CODEC = MineTunnelsStructure.simpleCodec(MineTunnelsStructure::new);
    public static final Direction[] facing = new Direction[]{Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH};
    public static final int[] railShape = new int[]{5, 4, 7, 6};

    protected MineTunnelsStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int lowestY = StructureUtils.getHeight((int)x, (int)z, (Structure.GenerationContext)context);
        if (x * x + z * z <= 160000 && lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return MineTunnelsStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            BlockPos tunnelPos;
            WorldgenRandom random = context.random();
            BlockPos centerPos = startChunk.getMiddleBlockPosition(lowestY);
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            Object2IntOpenHashMap tunnelsMap = new Object2IntOpenHashMap();
            Object2IntOpenHashMap translationMap = new Object2IntOpenHashMap();
            ArrayList<BlockPos> switchMap = new ArrayList<BlockPos>();
            HashMap<BlockPos, ResourceLocation> featureMap = new HashMap<BlockPos, ResourceLocation>();
            boolean setGate = 0.1666666f >= random.nextFloat();
            int gateType = random.nextInt(2);
            int maxY = 20;
            int minY = -40;
            int length = 100;
            BlockPos underPos = startChunk.getMiddleBlockPosition(random.nextInt(-30, 10));
            int yOffset = -1;
            int lengthGate = (int)((float)(centerPos.getY() - underPos.getY() - 4) * random.nextFloat());
            blockMap.put((Object)underPos, 0);
            MineTunnelsStructure.tunnels(maxY, minY, 0, length, 4, 6, 20, (Object2IntMap<BlockPos>)tunnelsMap, (Object2IntMap<BlockPos>)translationMap, switchMap, random, underPos.offset(3, 0, 0));
            MineTunnelsStructure.tunnels(maxY, minY, 0, length, 5, 6, 20, (Object2IntMap<BlockPos>)tunnelsMap, (Object2IntMap<BlockPos>)translationMap, switchMap, random, underPos.offset(-3, 0, 0));
            MineTunnelsStructure.tunnels(maxY, minY, 0, length, 6, 6, 20, (Object2IntMap<BlockPos>)tunnelsMap, (Object2IntMap<BlockPos>)translationMap, switchMap, random, underPos.offset(0, 0, 3));
            MineTunnelsStructure.tunnels(maxY, minY, 0, length, 7, 6, 20, (Object2IntMap<BlockPos>)tunnelsMap, (Object2IntMap<BlockPos>)translationMap, switchMap, random, underPos.offset(0, 0, -3));
            for (Object2IntMap.Entry tunnel : tunnelsMap.object2IntEntrySet()) {
                tunnelPos = (BlockPos)tunnel.getKey();
                StructureUtils.ball((double)(2.9 + 2.0 * random.nextDouble()), (BlockPos)tunnelPos, (int)0, (boolean)true, (Object2IntMap)blockMap);
            }
            for (Object2IntMap.Entry tunnel : tunnelsMap.object2IntEntrySet()) {
                tunnelPos = (BlockPos)tunnel.getKey();
                int xSet = tunnelPos.getX() - underPos.getX() + 5;
                int zSet = tunnelPos.getZ() - underPos.getZ() + 5;
                int tunnelFacing = tunnel.getIntValue();
                int facingType = tunnelFacing % 4;
                if (facingType == 0 || facingType == 1) {
                    StructureUtils.rectangular((BlockPos)tunnelPos.offset(0, yOffset, 1), (BlockPos)tunnelPos.offset(0, yOffset, -1), (int)1, (Object2IntMap)blockMap, (int)0);
                    if (tunnelFacing / 4 == 1) {
                        blockMap.put((Object)tunnelPos, 3);
                    } else if (tunnelFacing / 4 == 2) {
                        blockMap.put((Object)tunnelPos, 4 + facingType);
                    } else {
                        blockMap.put((Object)tunnelPos.offset(0, yOffset + 1, 0), railShape[facingType]);
                    }
                    if (xSet % 10 == 0) {
                        featureMap.put(tunnelPos.offset(0, yOffset, 1), RAIL_SUPPORT.location());
                        featureMap.put(tunnelPos.offset(0, yOffset, -1), RAIL_SUPPORT.location());
                    }
                } else {
                    StructureUtils.rectangular((BlockPos)tunnelPos.offset(1, yOffset, 0), (BlockPos)tunnelPos.offset(-1, yOffset, 0), (int)1, (Object2IntMap)blockMap, (int)0);
                    if (tunnelFacing / 4 == 1) {
                        blockMap.put((Object)tunnelPos, 2);
                    } else if (tunnelFacing / 4 == 2) {
                        blockMap.put((Object)tunnelPos, 4 + facingType);
                    } else {
                        blockMap.put((Object)tunnelPos, railShape[facingType]);
                    }
                    if (zSet % 10 == 0) {
                        featureMap.put(tunnelPos.offset(1, yOffset, 0), RAIL_SUPPORT.location());
                        featureMap.put(tunnelPos.offset(-1, yOffset, 0), RAIL_SUPPORT.location());
                    }
                }
                if (tunnelFacing <= 11) continue;
                blockMap.put((Object)tunnelPos, tunnelFacing - 4);
                StructureUtils.rectangular((BlockPos)tunnelPos.offset(1, yOffset, 1), (BlockPos)tunnelPos.offset(-1, yOffset, -1), (int)1, (Object2IntMap)blockMap, (int)0);
            }
            for (BlockPos blockPos : switchMap) {
                blockMap.put((Object)blockPos, 12);
                blockMap.put((Object)blockPos.offset(0, 1, 0), 13);
            }
            block8: for (Object2IntMap.Entry translation : translationMap.object2IntEntrySet()) {
                BlockPos translationPos = (BlockPos)translation.getKey();
                int type4 = translation.getIntValue() % 4;
                int facing2 = translation.getIntValue() / 4;
                blockMap.put((Object)translationPos, facing2 == 0 ? 20 : 21);
                switch (type4) {
                    case 0: {
                        blockMap.put((Object)translationPos.offset(0, -1, 0), 24);
                        continue block8;
                    }
                    case 1: {
                        featureMap.put(translationPos, RAIL_BOULDER.location());
                        continue block8;
                    }
                    case 3: {
                        featureMap.put(translationPos, RAIL_DART.location());
                        continue block8;
                    }
                }
                StructureUtils.ellipsoid((double)4.9, (double)10.9, (double)4.9, (BlockPos)translationPos.offset(0, -6, 0), (int)0, (boolean)true, (Object2IntMap)blockMap);
                StructureUtils.ball((double)7.9, (BlockPos)translationPos.offset(0, -12, 0), (int)0, (int)22, (boolean)true, (Object2IntMap)blockMap, (int)(translationPos.getY() - 12));
                StructureUtils.ball((double)6.4, (BlockPos)translationPos.offset(0, -12, 0), (int)0, (int)23, (boolean)true, (Object2IntMap)blockMap, (int)(translationPos.getY() - 12));
            }
            if (setGate) {
                StructureUtils.rectangular((BlockPos)centerPos.offset(3, 0, 3), (BlockPos)underPos.offset(-3, 1, -3), (int)0, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)centerPos.offset(3, 0, 3), (BlockPos)underPos.offset(-3, 3, -3), (int)15, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)centerPos.offset(3, 0, 3), (BlockPos)underPos.offset(2, 0, 2), (int)16, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)centerPos.offset(3, 0, -3), (BlockPos)underPos.offset(2, 0, -2), (int)16, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)centerPos.offset(-3, 0, 3), (BlockPos)underPos.offset(-2, 0, 2), (int)16, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)centerPos.offset(-3, 0, -3), (BlockPos)underPos.offset(-2, 0, -2), (int)16, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)underPos.offset(3, -1, 3), (BlockPos)underPos.offset(-3, -1, -3), (int)16, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)underPos.offset(2, -1, 2), (BlockPos)underPos.offset(-2, -1, -2), (int)15, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)underPos.offset(2, 1, 2), (BlockPos)underPos.offset(-2, 4, -2), (int)0, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)underPos.offset(1, 1, 1), (BlockPos)centerPos.offset(-1, 0, -1), (int)0, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)centerPos.offset(3, 0, 3), (BlockPos)underPos.offset(3, 0, 3), (int)14, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)centerPos.offset(3, 0, -3), (BlockPos)underPos.offset(3, 0, -3), (int)14, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)centerPos.offset(-3, 0, 3), (BlockPos)underPos.offset(-3, 0, 3), (int)14, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)centerPos.offset(-3, 0, -3), (BlockPos)underPos.offset(-3, 0, -3), (int)14, (Object2IntMap)blockMap, (int)0);
                if (gateType == 0) {
                    StructureUtils.rectangular((BlockPos)centerPos.offset(1, 0, 0), (BlockPos)centerPos.offset(1, -lengthGate, 0), (int)19, (Object2IntMap)blockMap, (int)0);
                    StructureUtils.rectangular((BlockPos)centerPos.offset(-1, 0, 0), (BlockPos)centerPos.offset(-1, -lengthGate, 0), (int)19, (Object2IntMap)blockMap, (int)0);
                    StructureUtils.rectangular((BlockPos)centerPos.offset(1, -lengthGate, 0), (BlockPos)centerPos.offset(-1, -lengthGate, 0), (int)18, (Object2IntMap)blockMap, (int)0);
                } else {
                    StructureUtils.rectangular((BlockPos)centerPos.offset(0, 0, 1), (BlockPos)centerPos.offset(0, -lengthGate, 1), (int)19, (Object2IntMap)blockMap, (int)0);
                    StructureUtils.rectangular((BlockPos)centerPos.offset(0, 0, -1), (BlockPos)centerPos.offset(0, -lengthGate, -1), (int)19, (Object2IntMap)blockMap, (int)0);
                    StructureUtils.rectangular((BlockPos)centerPos.offset(0, -lengthGate, 1), (BlockPos)centerPos.offset(0, -lengthGate, -1), (int)18, (Object2IntMap)blockMap, (int)0);
                }
            } else {
                StructureUtils.rectangular((BlockPos)underPos.offset(3, -1, 3), (BlockPos)underPos.offset(-3, -1, -3), (int)16, (Object2IntMap)blockMap, (int)0);
                StructureUtils.rectangular((BlockPos)underPos.offset(2, -1, 2), (BlockPos)underPos.offset(-2, -1, -2), (int)15, (Object2IntMap)blockMap, (int)0);
            }
            for (int xF = -2; xF < 3; ++xF) {
                for (int zF = -2; zF < 3; ++zF) {
                    featureMap.put(underPos.offset(xF, -2, zF), RAIL_STONE_BRICKS.location());
                }
            }
            featureMap.put(underPos.offset(3, -2, 3), RAIL_SPRUCE_LOG.location());
            featureMap.put(underPos.offset(3, -2, -3), RAIL_SPRUCE_LOG.location());
            featureMap.put(underPos.offset(-3, -2, 3), RAIL_SPRUCE_LOG.location());
            featureMap.put(underPos.offset(-3, -2, -3), RAIL_SPRUCE_LOG.location());
            featureMap.put(underPos.offset(3, -2, 2), RAIL_TUFF_BRICKS.location());
            featureMap.put(underPos.offset(3, -2, -2), RAIL_TUFF_BRICKS.location());
            featureMap.put(underPos.offset(-3, -2, 2), RAIL_TUFF_BRICKS.location());
            featureMap.put(underPos.offset(-3, -2, -2), RAIL_TUFF_BRICKS.location());
            featureMap.put(underPos.offset(2, -2, 3), RAIL_TUFF_BRICKS.location());
            featureMap.put(underPos.offset(2, -2, -3), RAIL_TUFF_BRICKS.location());
            featureMap.put(underPos.offset(-2, -2, 3), RAIL_TUFF_BRICKS.location());
            featureMap.put(underPos.offset(-2, -2, -3), RAIL_TUFF_BRICKS.location());
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), (BlockState)((EverPoweredRailBlock)((Object)((Object)FunctionalBlocks.EVER_POWERED_RAIL.get()))).defaultBlockState().setValue((Property)PoweredRailBlock.SHAPE, (Comparable)RailShape.NORTH_SOUTH), (BlockState)((EverPoweredRailBlock)((Object)((Object)FunctionalBlocks.EVER_POWERED_RAIL.get()))).defaultBlockState().setValue((Property)PoweredRailBlock.SHAPE, (Comparable)RailShape.EAST_WEST), (BlockState)((EverPoweredRailBlock)((Object)((Object)FunctionalBlocks.EVER_POWERED_RAIL.get()))).defaultBlockState().setValue((Property)PoweredRailBlock.SHAPE, (Comparable)RailShape.ASCENDING_EAST), (BlockState)((EverPoweredRailBlock)((Object)((Object)FunctionalBlocks.EVER_POWERED_RAIL.get()))).defaultBlockState().setValue((Property)PoweredRailBlock.SHAPE, (Comparable)RailShape.ASCENDING_WEST), (BlockState)((EverPoweredRailBlock)((Object)((Object)FunctionalBlocks.EVER_POWERED_RAIL.get()))).defaultBlockState().setValue((Property)PoweredRailBlock.SHAPE, (Comparable)RailShape.ASCENDING_SOUTH), (BlockState)((EverPoweredRailBlock)((Object)((Object)FunctionalBlocks.EVER_POWERED_RAIL.get()))).defaultBlockState().setValue((Property)PoweredRailBlock.SHAPE, (Comparable)RailShape.ASCENDING_NORTH), (BlockState)Blocks.RAIL.defaultBlockState().setValue((Property)RailBlock.SHAPE, (Comparable)RailShape.NORTH_EAST), (BlockState)Blocks.RAIL.defaultBlockState().setValue((Property)RailBlock.SHAPE, (Comparable)RailShape.SOUTH_WEST), (BlockState)Blocks.RAIL.defaultBlockState().setValue((Property)RailBlock.SHAPE, (Comparable)RailShape.SOUTH_EAST), (BlockState)Blocks.RAIL.defaultBlockState().setValue((Property)RailBlock.SHAPE, (Comparable)RailShape.NORTH_WEST), Blocks.CHISELED_TUFF_BRICKS.defaultBlockState(), (BlockState)Blocks.LEVER.defaultBlockState().setValue((Property)FaceAttachedHorizontalDirectionalBlock.FACE, (Comparable)AttachFace.FLOOR), Blocks.SPRUCE_LOG.defaultBlockState(), Blocks.STONE_BRICKS.defaultBlockState(), Blocks.TUFF_BRICKS.defaultBlockState(), Blocks.LANTERN.defaultBlockState(), (BlockState)Blocks.SPRUCE_TRAPDOOR.defaultBlockState().setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.TOP), Blocks.CHAIN.defaultBlockState(), (BlockState)Blocks.DETECTOR_RAIL.defaultBlockState().setValue((Property)DetectorRailBlock.SHAPE, (Comparable)RailShape.EAST_WEST), (BlockState)Blocks.DETECTOR_RAIL.defaultBlockState().setValue((Property)DetectorRailBlock.SHAPE, (Comparable)RailShape.NORTH_SOUTH), Blocks.STONE.defaultBlockState(), Blocks.LAVA.defaultBlockState(), ((InstantExplosionBlock)FunctionalBlocks.INSTANTANEOUS_EXPLOSION_TNT.get()).defaultBlockState()}), featureMap, (StructurePiecesBuilder)builder);
            if (setGate) {
                if (gateType == 0) {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(context.structureTemplateManager(), "mine_gate", centerPos.offset(-4, 0, -4), true, true, Rotation.NONE));
                } else {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(context.structureTemplateManager(), "mine_gate", centerPos.offset(-4, 0, 4), true, true, Rotation.COUNTERCLOCKWISE_90));
                }
            }
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.MINE_TUNNELS.get();
    }

    private static void tunnels(int maxY, int minY, int length, int maxLength, int ownFacing, int rotateCD, int translationCD, Object2IntMap<BlockPos> tunnelsMap, Object2IntMap<BlockPos> translationMap, List<BlockPos> switchMap, WorldgenRandom random, BlockPos ownPos) {
        float tnt = 0.005f;
        float boulder = 0.005f;
        float dart = 0.005f;
        float lava = 0.0025f;
        float rotate = 0.01f;
        if (length + 10 > maxLength) {
            ownFacing = ownFacing % 4 + 4;
        }
        int facing4 = ownFacing % 4;
        int upDown = ownFacing / 4;
        int face = facing4 == 0 || facing4 == 1 ? 0 : 4;
        Direction offset = facing[facing4];
        if (length < maxLength) {
            if (upDown == 1) {
                if (translationCD <= 0) {
                    float randomTR = random.nextFloat();
                    if (tnt >= randomTR) {
                        translationMap.put((Object)ownPos, face);
                        translationCD = 200;
                    } else if (tnt + boulder >= randomTR) {
                        translationMap.put((Object)ownPos, 1 + face);
                        translationCD = 200;
                    } else if (tnt + boulder + dart >= randomTR) {
                        translationMap.put((Object)ownPos, 2 + face);
                        translationCD = 200;
                    } else if (tnt + boulder + dart + lava >= randomTR) {
                        translationMap.put((Object)ownPos, 3 + face);
                        translationCD = 200;
                    }
                } else if (rotateCD <= 0 && rotate >= random.nextFloat()) {
                    rotateCD = 5;
                    int setFacing = random.nextInt(2);
                    if (facing4 == 0 || facing4 == 1) {
                        MineTunnelsStructure.tunnels(maxY, minY, length + 1 + random.nextInt(-10, 11), maxLength, 6 + setFacing, rotateCD - 1, 2, tunnelsMap, translationMap, switchMap, random, ownPos.offset(0, 0, setFacing == 0 ? 1 : -1));
                        switchMap.add(ownPos.offset(0, 0, setFacing == 0 ? -1 : 1));
                        tunnelsMap.put((Object)ownPos, 14 + setFacing);
                    } else {
                        MineTunnelsStructure.tunnels(maxY, minY, length + 1 + random.nextInt(-10, 11), maxLength, 4 + setFacing, rotateCD - 1, 2, tunnelsMap, translationMap, switchMap, random, ownPos.offset(setFacing == 0 ? 1 : -1, 0, 0));
                        switchMap.add(ownPos.offset(setFacing == 0 ? -1 : 1, 0, 0));
                        tunnelsMap.put((Object)ownPos, 12 + setFacing);
                    }
                }
                float randomCount = random.nextFloat();
                if (0.025f >= randomCount && ownPos.getY() <= maxY) {
                    MineTunnelsStructure.tunnels(maxY, minY, length + 1, maxLength, facing4 + (upDown + 1) * 4, rotateCD - 1, translationCD - 1, tunnelsMap, translationMap, switchMap, random, ownPos.offset(offset.getStepX(), 0, offset.getStepZ()));
                } else if (0.975f <= randomCount && ownPos.getY() >= minY) {
                    MineTunnelsStructure.tunnels(maxY, minY, length + 1, maxLength, facing4, rotateCD - 1, translationCD - 1, tunnelsMap, translationMap, switchMap, random, ownPos.offset(offset.getStepX(), 0, offset.getStepZ()));
                } else {
                    MineTunnelsStructure.tunnels(maxY, minY, length + 1, maxLength, facing4 + upDown * 4, rotateCD - 1, translationCD - 1, tunnelsMap, translationMap, switchMap, random, ownPos.offset(offset.getStepX(), 0, offset.getStepZ()));
                }
                tunnelsMap.put((Object)ownPos, ownFacing);
            } else if (upDown == 0) {
                if (ownPos.getY() <= minY || 0.1f >= random.nextFloat()) {
                    MineTunnelsStructure.tunnels(maxY, minY, length + 1, maxLength, facing4 + (upDown + 1) * 4, 2, translationCD - 1, tunnelsMap, translationMap, switchMap, random, ownPos.offset(offset.getStepX(), -1, offset.getStepZ()));
                } else {
                    MineTunnelsStructure.tunnels(maxY, minY, length + 1, maxLength, facing4, 2, translationCD - 1, tunnelsMap, translationMap, switchMap, random, ownPos.offset(offset.getStepX(), -1, offset.getStepZ()));
                }
                tunnelsMap.put((Object)ownPos.offset(0, -1, 0), ownFacing);
            } else if (upDown == 2) {
                if (ownPos.getY() >= maxY || 0.1f >= random.nextFloat()) {
                    MineTunnelsStructure.tunnels(maxY, minY, length + 1, maxLength, facing4 + (upDown - 1) * 4, 2, translationCD - 1, tunnelsMap, translationMap, switchMap, random, ownPos.offset(offset.getStepX(), 1, offset.getStepZ()));
                } else {
                    MineTunnelsStructure.tunnels(maxY, minY, length + 1, maxLength, facing4 + upDown * 4, 2, translationCD - 1, tunnelsMap, translationMap, switchMap, random, ownPos.offset(offset.getStepX(), 1, offset.getStepZ()));
                }
                tunnelsMap.put((Object)ownPos, ownFacing);
            }
        }
    }
}

