/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.block.ModBlocks;

public class ShimmerLakeStructure
extends Structure {
    public static final MapCodec<ShimmerLakeStructure> CODEC = ShimmerLakeStructure.simpleCodec(ShimmerLakeStructure::new);
    private static final ResourceLocation[] feature = new ResourceLocation[]{Confluence.asResource("amber_tree"), Confluence.asResource("diamond_tree"), Confluence.asResource("jade_tree"), Confluence.asResource("ruby_tree"), Confluence.asResource("sapphire_tree"), Confluence.asResource("topaz_tree"), Confluence.asResource("amethyst_tree")};

    public ShimmerLakeStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int lowestY = StructureUtils.getHeight((int)x, (int)z, (Structure.GenerationContext)context);
        if (x * x + z * z <= 160000 || lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return ShimmerLakeStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            WorldgenRandom random = context.random();
            BlockPos centerPos = startChunk.getMiddleBlockPosition(random.nextInt(-40, 10));
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            HashMap featureMap = new HashMap();
            LinkedList vctPosList = new LinkedList();
            List posOut = VectorUtils.ellipsoidPos((double)36.0, (double)12.0, (double)36.0, (BlockPos)centerPos, (float)0.03f, (WorldgenRandom)random);
            List posIn = VectorUtils.ellipsoidPos((double)24.0, (double)9.0, (double)24.0, (BlockPos)centerPos, (float)0.03f, (WorldgenRandom)random);
            StructureUtils.lineSet((List)posOut, (double)11.5, (double)11.5, (int)1, (boolean)true, (Object2IntMap)blockMap);
            StructureUtils.lineSet((List)posOut, (double)8.5, (double)8.5, (int)0, (int)1, (boolean)true, (Object2IntMap)blockMap, (int)(centerPos.getY() - 2));
            StructureUtils.lineSet((List)posIn, (double)6.5, (double)6.5, (int)0, (int)2, (boolean)true, (Object2IntMap)blockMap, (int)(centerPos.getY() - 2));
            VectorUtils.roundPos((BlockPos)centerPos.offset(0, -1, 0), (double)34.0, (WorldgenRandom)random, vctPosList, (int)3, (int)random.nextInt(14, 17), (float)0.0f);
            StructureUtils.lineSetFeature(vctPosList, featureMap, (ResourceLocation[])feature, (WorldgenRandom)random);
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), Blocks.STONE.defaultBlockState(), ((LiquidBlock)ModBlocks.SHIMMER.get()).defaultBlockState()}), featureMap, (StructurePiecesBuilder)builder);
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.SHIMMER_LAKE.get();
    }
}

