/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jade;

import java.util.IdentityHashMap;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.lib.common.block.ISimulatorBlock;
import org.confluence.mod.client.gameevent.GoblinArmyProgressRenderer;
import org.confluence.mod.common.block.common.BaseChestBlock;
import org.confluence.mod.common.block.common.TombstoneBlock;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.BehaviourPressurePlateBlock;
import org.confluence.mod.common.block.functional.DeathChestBlock;
import org.confluence.mod.common.block.functional.SignalPressurePlateBlock;
import org.confluence.mod.common.block.functional.crafting.AltarBlock;
import org.confluence.mod.common.entity.TreasureBagItemEntity;
import org.confluence.mod.common.init.block.ChestBlocks;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.integration.create.ponder.PonderHelper;
import org.confluence.mod.integration.jade.NetworkComponentProvider;
import org.confluence.mod.integration.jade.PonderComponentProvider;
import org.confluence.mod.integration.jade.TombstoneInfoProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;

@WailaPlugin
public final class ModJadePlugin
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)NetworkComponentProvider.INSTANCE, AbstractMechanicalBlock.BEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)NetworkComponentProvider.INSTANCE, DeathChestBlock.BEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)TombstoneInfoProvider.INSTANCE, TombstoneBlock.BEntity.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)NetworkComponentProvider.INSTANCE, AbstractMechanicalBlock.class);
        registration.registerBlockComponent((IComponentProvider)NetworkComponentProvider.INSTANCE, DeathChestBlock.class);
        registration.registerBlockComponent((IComponentProvider)NetworkComponentProvider.INSTANCE, SignalPressurePlateBlock.class);
        registration.registerBlockComponent((IComponentProvider)NetworkComponentProvider.INSTANCE, BehaviourPressurePlateBlock.class);
        if (PonderHelper.IS_LOADED) {
            registration.registerBlockComponent((IComponentProvider)PonderComponentProvider.INSTANCE, AltarBlock.class);
        }
        registration.registerBlockComponent((IComponentProvider)TombstoneInfoProvider.INSTANCE, TombstoneBlock.class);
        IdentityHashMap<Block, BlockState> hideMap = new IdentityHashMap<Block, BlockState>();
        hideMap.put((Block)ChestBlocks.DEATH_GOLDEN_CHEST.get(), ((BaseChestBlock)((Object)ChestBlocks.GOLDEN_CHEST.get())).defaultBlockState());
        hideMap.put((Block)ChestBlocks.DEATH_WOODEN_CHEST.get(), Blocks.CHEST.defaultBlockState());
        hideMap.put((Block)FunctionalBlocks.OAK_LOG_BOULDER.get(), Blocks.OAK_LOG.defaultBlockState());
        registration.addRayTraceCallback((hitResult, accessor, originalAccessor) -> {
            TreasureBagItemEntity entity;
            EntityAccessor entityAccessor;
            Entity patt0$temp;
            if (accessor instanceof BlockAccessor) {
                BlockAccessor blockAccessor = (BlockAccessor)accessor;
                Player player = accessor.getPlayer();
                if (player.isCreative()) {
                    return accessor;
                }
                Block block = blockAccessor.getBlock();
                if (block instanceof ISimulatorBlock) {
                    ISimulatorBlock simulatorBlock = (ISimulatorBlock)block;
                    return registration.blockAccessor().from(blockAccessor).blockState(simulatorBlock.getSimulatedBlock(true)).build();
                }
                BlockState blockState = (BlockState)hideMap.get(block);
                if (blockState != null) {
                    return registration.blockAccessor().from(blockAccessor).blockState(blockState).build();
                }
            } else if (accessor instanceof EntityAccessor && (patt0$temp = (entityAccessor = (EntityAccessor)accessor).getEntity()) instanceof TreasureBagItemEntity && !(entity = (TreasureBagItemEntity)patt0$temp).isOwner(accessor.getPlayer())) {
                return null;
            }
            return accessor;
        });
        registration.addAfterRenderCallback((iBoxElement, tooltipRect, guiGraphics, accessor) -> {
            Rect2i rect = tooltipRect.rect;
            GoblinArmyProgressRenderer.yOffset = rect.getY() + rect.getHeight();
        });
    }
}

