/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import org.confluence.lib.common.recipe.AbstractAmountRecipe;
import org.confluence.lib.common.recipe.AmountIngredient;
import org.confluence.mod.Confluence;
import org.confluence.mod.StartupConfigs;
import org.confluence.mod.client.gui.AchievementToast;
import org.confluence.mod.client.gui.container.AlchemyTableScreen;
import org.confluence.mod.client.gui.container.CookingPotScreen;
import org.confluence.mod.client.gui.container.CrystalBallScreen;
import org.confluence.mod.client.gui.container.DyeVatScreen;
import org.confluence.mod.client.gui.container.FletchingTableScreen;
import org.confluence.mod.client.gui.container.HardmodeAnvilScreen;
import org.confluence.mod.client.gui.container.HardmodeForgeScreen;
import org.confluence.mod.client.gui.container.HeavyWorkBenchScreen;
import org.confluence.mod.client.gui.container.HellforgeScreen;
import org.confluence.mod.client.gui.container.LoomScreen;
import org.confluence.mod.client.gui.container.SawmillScreen;
import org.confluence.mod.client.gui.container.SkyMillScreen;
import org.confluence.mod.client.gui.container.SolidifierScreen;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.init.ModDataMaps;
import org.confluence.mod.common.init.ModMenuTypes;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.armor.ModArmorBonus;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.mod.common.menu.HardmodeAnvilMenu;
import org.confluence.mod.common.menu.HeavyWorkBenchMenu;
import org.confluence.mod.common.menu.LoomMenu;
import org.confluence.mod.common.menu.SawmillMenu;
import org.confluence.mod.common.menu.SolidifierMenu;
import org.confluence.mod.common.recipe.HardmodeAnvilRecipe;
import org.confluence.mod.common.recipe.HeavyWorkBenchRecipe;
import org.confluence.mod.common.recipe.LoomRecipe;
import org.confluence.mod.common.recipe.SawmillRecipe;
import org.confluence.mod.common.recipe.SolidifierRecipe;
import org.confluence.mod.integration.jei.EitherRecipe4xHelper;
import org.confluence.mod.integration.jei.ExtraInventoryHandler;
import org.confluence.mod.integration.jei.JeiHelper;
import org.confluence.mod.integration.jei.category.AlchemyTableCategory;
import org.confluence.mod.integration.jei.category.AltarCategory;
import org.confluence.mod.integration.jei.category.ArmorSetBonusCategory;
import org.confluence.mod.integration.jei.category.BrewingStandTerraPotionCategory;
import org.confluence.mod.integration.jei.category.CookingPotCategory;
import org.confluence.mod.integration.jei.category.CrystalBallCategory;
import org.confluence.mod.integration.jei.category.DyeVatCategory;
import org.confluence.mod.integration.jei.category.ExtractinatorCategory;
import org.confluence.mod.integration.jei.category.FletchingTableCategory;
import org.confluence.mod.integration.jei.category.HardmodeAnvilCategory;
import org.confluence.mod.integration.jei.category.HardmodeForgeCategory;
import org.confluence.mod.integration.jei.category.HeavyWorkBenchCategory;
import org.confluence.mod.integration.jei.category.HellforgeCategory;
import org.confluence.mod.integration.jei.category.LoomCategory;
import org.confluence.mod.integration.jei.category.SawmillCategory;
import org.confluence.mod.integration.jei.category.ShimmerItemTransmutationCategory;
import org.confluence.mod.integration.jei.category.SkyMillCategory;
import org.confluence.mod.integration.jei.category.SolidifierCategory;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public final class ModJeiPlugin
implements IModPlugin {
    public static final ResourceLocation UID = Confluence.asResource("jei_plugin");
    public static final ResourceLocation ARROW_DOWN = Confluence.asResource("textures/gui/arrow_down.png");
    public static final ResourceLocation ARROW_RIGHT = Confluence.asResource("textures/gui/arrow_right.png");
    public static IJeiRuntime jeiRuntime;

    public static List<ToastComponent.ToastInstance<?>> filterAchievements(List<ToastComponent.ToastInstance<?>> original) {
        ArrayList list = new ArrayList(original);
        list.removeIf(toastInstance -> toastInstance.getToast() instanceof AchievementToast);
        return list;
    }

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new ShimmerItemTransmutationCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SkyMillCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new AltarCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HellforgeCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HeavyWorkBenchCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new AlchemyTableCategory(jeiHelpers)});
        if (((Boolean)CommonConfigs.FLETCHING_MENU.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new FletchingTableCategory(jeiHelpers)});
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new CookingPotCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SawmillCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SolidifierCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HardmodeAnvilCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ExtractinatorCategory(jeiHelpers, ExtractinatorCategory.EXTRACTINATOR, (Block)FunctionalBlocks.EXTRACTINATOR.get())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ExtractinatorCategory(jeiHelpers, ExtractinatorCategory.CHLOROPHYTE_EXTRACTINATOR, (Block)FunctionalBlocks.CHLOROPHYTE_EXTRACTINATOR.get())});
        registration.addRecipeCategories(new IRecipeCategory[]{new HardmodeForgeCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new LoomCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DyeVatCategory(jeiHelpers)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrystalBallCategory(jeiHelpers)});
        if (StartupConfigs.brewingStandRecipe()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new BrewingStandTerraPotionCategory()});
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new ArmorSetBonusCategory(jeiHelpers)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        RecipeManager recipeManager = level.getRecipeManager();
        registration.addRecipes(ShimmerItemTransmutationCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.ITEM_TRANSMUTATION_TYPE.get()));
        registration.addRecipes(SkyMillCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.SKY_MILL_TYPE.get()));
        registration.addRecipes(AltarCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.ALTAR_TYPE.get()));
        registration.addRecipes(HellforgeCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.HELLFORGE_TYPE.get()));
        registration.addRecipes(HeavyWorkBenchCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.HEAVY_WORK_BENCH_TYPE.get()));
        registration.addRecipes(AlchemyTableCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.ALCHEMY_TABLE_TYPE.get()));
        if (((Boolean)CommonConfigs.FLETCHING_MENU.get()).booleanValue()) {
            registration.addRecipes(FletchingTableCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.FLETCHING_TABLE_TYPE.get()));
        }
        registration.addRecipes(CookingPotCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.COOKING_POT_TYPE.get()));
        registration.addRecipes(SawmillCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.SAWMILL_TYPE.get()));
        registration.addRecipes(SolidifierCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.SOLIDIFIER_TYPE.get()));
        registration.addRecipes(HardmodeAnvilCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.HARDMODE_ANVIL_TYPE.get()));
        registration.addRecipes(ExtractinatorCategory.EXTRACTINATOR, ExtractinatorCategory.collectAll(ModDataMaps.EXTRACTINATOR, level.registryAccess()));
        registration.addRecipes(ExtractinatorCategory.CHLOROPHYTE_EXTRACTINATOR, ExtractinatorCategory.collectAll(ModDataMaps.CHLOROPHYTE_EXTRACTINATOR, level.registryAccess()));
        registration.addRecipes(HardmodeForgeCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.HARDMODE_FORGE_TYPE.get()));
        registration.addRecipes(LoomCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.LOOM_TYPE.get()));
        registration.addRecipes(DyeVatCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.DYE_VAT_TYPE.get()));
        registration.addRecipes(CrystalBallCategory.TYPE, recipeManager.getAllRecipesFor(ModRecipes.CRYSTAL_BALL_TYPE.get()));
        if (StartupConfigs.brewingStandRecipe()) {
            registration.addRecipes(BrewingStandTerraPotionCategory.TYPE, BrewingStandTerraPotionCategory.Recipe.getAllRecipes());
        }
        registration.addRecipes(ArmorSetBonusCategory.TYPE, ModArmorBonus.getValueMap().entrySet().stream().map(ArmorSetBonusCategory.Holder::new).toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(ToolItems.BOTTOMLESS_SHIMMER_BUCKET, new RecipeType[]{ShimmerItemTransmutationCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.SKY_MILL, new RecipeType[]{SkyMillCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.DEMON_ALTAR, new RecipeType[]{AltarCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.CRIMSON_ALTAR, new RecipeType[]{AltarCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.HELLFORGE, new RecipeType[]{HellforgeCategory.TYPE, RecipeTypes.BLASTING});
        registration.addRecipeCatalyst(FunctionalBlocks.HEAVY_WORK_BENCH, new RecipeType[]{HeavyWorkBenchCategory.TYPE, RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(FunctionalBlocks.ALCHEMY_TABLE, new RecipeType[]{AlchemyTableCategory.TYPE});
        if (((Boolean)CommonConfigs.FLETCHING_MENU.get()).booleanValue()) {
            registration.addRecipeCatalyst((ItemLike)Blocks.FLETCHING_TABLE, new RecipeType[]{FletchingTableCategory.TYPE});
        }
        registration.addRecipeCatalyst(FunctionalBlocks.LEAD_ANVIL, new RecipeType[]{RecipeTypes.ANVIL});
        registration.addRecipeCatalyst(FunctionalBlocks.COOKING_POT, new RecipeType[]{CookingPotCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.CAULDRON, new RecipeType[]{CookingPotCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.SAWMILL, new RecipeType[]{SawmillCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.SOLIDIFIER, new RecipeType[]{SolidifierCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.MYTHRIL_ANVIL, new RecipeType[]{HardmodeAnvilCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.ORICHALCUM_ANVIL, new RecipeType[]{HardmodeAnvilCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.EXTRACTINATOR, new RecipeType[]{ExtractinatorCategory.EXTRACTINATOR});
        registration.addRecipeCatalyst(FunctionalBlocks.CHLOROPHYTE_EXTRACTINATOR, new RecipeType[]{ExtractinatorCategory.CHLOROPHYTE_EXTRACTINATOR});
        registration.addRecipeCatalyst(FunctionalBlocks.ADAMANTITE_FORGE, new RecipeType[]{HardmodeForgeCategory.TYPE, HellforgeCategory.TYPE, RecipeTypes.BLASTING});
        registration.addRecipeCatalyst(FunctionalBlocks.TITANIUM_FORGE, new RecipeType[]{HardmodeForgeCategory.TYPE, HellforgeCategory.TYPE, RecipeTypes.BLASTING});
        registration.addRecipeCatalyst(FunctionalBlocks.LOOM, new RecipeType[]{LoomCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.DYE_VAT, new RecipeType[]{DyeVatCategory.TYPE});
        registration.addRecipeCatalyst(FunctionalBlocks.CRYSTAL_BALL, new RecipeType[]{CrystalBallCategory.TYPE});
        if (StartupConfigs.brewingStandRecipe()) {
            registration.addRecipeCatalyst((ItemLike)Items.BREWING_STAND, new RecipeType[]{BrewingStandTerraPotionCategory.TYPE});
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(HeavyWorkBenchScreen.class, 95, 32, 28, 23, new RecipeType[]{HeavyWorkBenchCategory.TYPE});
        registration.addRecipeClickArea(SawmillScreen.class, 95, 32, 28, 23, new RecipeType[]{SawmillCategory.TYPE});
        registration.addRecipeClickArea(SolidifierScreen.class, 95, 32, 28, 23, new RecipeType[]{SolidifierCategory.TYPE});
        if (((Boolean)CommonConfigs.FLETCHING_MENU.get()).booleanValue()) {
            registration.addRecipeClickArea(FletchingTableScreen.class, 87, 31, 28, 23, new RecipeType[]{FletchingTableCategory.TYPE});
        }
        registration.addRecipeClickArea(HellforgeScreen.class, 89, 31, 28, 23, new RecipeType[]{HellforgeCategory.TYPE});
        registration.addRecipeClickArea(SkyMillScreen.class, 34, 35, 18, 18, new RecipeType[]{SkyMillCategory.TYPE});
        registration.addRecipeClickArea(AlchemyTableScreen.class, 79, 38, 18, 20, new RecipeType[]{AlchemyTableCategory.TYPE});
        registration.addRecipeClickArea(CookingPotScreen.class, 78, 36, 46, 15, new RecipeType[]{CookingPotCategory.TYPE});
        registration.addRecipeClickArea(HardmodeAnvilScreen.class, 78, 36, 46, 15, new RecipeType[]{HardmodeAnvilCategory.TYPE});
        registration.addRecipeClickArea(HardmodeForgeScreen.class, 89, 31, 28, 23, new RecipeType[]{HardmodeForgeCategory.TYPE});
        registration.addRecipeClickArea(LoomScreen.class, 95, 32, 28, 23, new RecipeType[]{LoomCategory.TYPE});
        registration.addRecipeClickArea(DyeVatScreen.class, 87, 36, 22, 15, new RecipeType[]{DyeVatCategory.TYPE});
        registration.addRecipeClickArea(CrystalBallScreen.class, 69, 36, 22, 15, new RecipeType[]{CrystalBallCategory.TYPE});
        registration.addGlobalGuiHandler((IGlobalGuiHandler)new ExtraInventoryHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        EitherRecipe4xHelper.register(registration, HardmodeAnvilRecipe.class, HardmodeAnvilMenu.class, ModMenuTypes.HARDMODE_ANVIL.get(), HardmodeAnvilRecipe::new, HardmodeAnvilCategory.TYPE, false);
        EitherRecipe4xHelper.register(registration, HeavyWorkBenchRecipe.class, HeavyWorkBenchMenu.class, ModMenuTypes.HEAVY_WORK_BENCH.get(), HeavyWorkBenchRecipe::new, HeavyWorkBenchCategory.TYPE, true);
        EitherRecipe4xHelper.register(registration, LoomRecipe.class, LoomMenu.class, ModMenuTypes.LOOM.get(), LoomRecipe::new, LoomCategory.TYPE, false);
        EitherRecipe4xHelper.register(registration, SawmillRecipe.class, SawmillMenu.class, ModMenuTypes.SAWMILL.get(), SawmillRecipe::new, SawmillCategory.TYPE, false);
        EitherRecipe4xHelper.register(registration, SolidifierRecipe.class, SolidifierMenu.class, ModMenuTypes.SOLIDIFIER.get(), SolidifierRecipe::new, SolidifierCategory.TYPE, false);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ModJeiPlugin.jeiRuntime = jeiRuntime;
    }

    public static void drawArrowDown(GuiGraphics guiGraphics, int x, int y, boolean usable) {
        guiGraphics.blit(ARROW_DOWN, x, y, usable ? 0.0f : 21.0f, 0.0f, 21, 28, 42, 42);
    }

    public static void drawArrowRight(GuiGraphics guiGraphics, int x, int y, boolean usable) {
        guiGraphics.blit(ARROW_RIGHT, x, y, 0.0f, usable ? 0.0f : 21.0f, 28, 21, 42, 42);
    }

    public static void set4IngredientsRecipe(IRecipeLayoutBuilder builder, RecipeHolder<? extends AbstractAmountRecipe<?>> recipe) {
        NonNullList ingredients = ((AbstractAmountRecipe)recipe.value()).getIngredients();
        int size = ingredients.size();
        if (size == 1) {
            ModJeiPlugin.addInput(builder, 24, 8, (Ingredient)ingredients.getFirst(), true);
        } else if (size == 2) {
            ModJeiPlugin.addInput(builder, 15, 8, (Ingredient)ingredients.get(0), true);
            ModJeiPlugin.addInput(builder, 33, 8, (Ingredient)ingredients.get(1), true);
        } else if (size == 3) {
            ModJeiPlugin.addInput(builder, 15, 15, (Ingredient)ingredients.get(0), true);
            ModJeiPlugin.addInput(builder, 33, 15, (Ingredient)ingredients.get(1), true);
            ModJeiPlugin.addInput(builder, 24, 1, (Ingredient)ingredients.get(2), true);
        } else {
            ModJeiPlugin.addInput(builder, 15, -1, (Ingredient)ingredients.get(0), true);
            ModJeiPlugin.addInput(builder, 15, 17, (Ingredient)ingredients.get(1), true);
            ModJeiPlugin.addInput(builder, 33, -1, (Ingredient)ingredients.get(2), true);
            ModJeiPlugin.addInput(builder, 33, 17, (Ingredient)ingredients.get(3), true);
        }
        ((IRecipeSlotBuilder)builder.addOutputSlot(88, 8).addItemStack(((AbstractAmountRecipe)recipe.value()).getResultItem(null))).setOutputSlotBackground();
        builder.setShapeless();
    }

    public static void addInput(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        ModJeiPlugin.addInput(builder, x, y, ingredient, false);
    }

    public static void addInput(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient, boolean directSlot) {
        if (!ingredient.isEmpty()) {
            IRecipeSlotBuilder sb;
            ICustomIngredient iCustomIngredient = ingredient.getCustomIngredient();
            if (iCustomIngredient instanceof AmountIngredient) {
                AmountIngredient amountIngredient = (AmountIngredient)iCustomIngredient;
                sb = (IRecipeSlotBuilder)builder.addInputSlot(x, y).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, amountIngredient.getItems().toList());
            } else {
                sb = (IRecipeSlotBuilder)builder.addInputSlot(x, y).addIngredients(ingredient);
            }
            if (directSlot) {
                sb.setStandardSlotBackground();
            }
        }
    }

    public static boolean handleShowUses(int keyCode, int scanCode, @Nullable ItemStack spawnEgg) {
        if (spawnEgg != null && jeiRuntime != null && JeiHelper.showUses != null && JeiHelper.showUses.matches(keyCode, scanCode)) {
            IFocus focus = jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.CATALYST, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)spawnEgg);
            jeiRuntime.getRecipesGui().show(focus);
            return true;
        }
        return false;
    }
}

