/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.confluence.lib.common.menu.EitherAmountContainerMenu4x;
import org.confluence.lib.common.recipe.AmountIngredient;
import org.confluence.lib.common.recipe.EitherAmountRecipe4x;
import org.confluence.lib.common.recipe.MenuRecipeInput;
import org.confluence.lib.network.IPacketC2S;
import org.confluence.mod.Confluence;
import org.jetbrains.annotations.Nullable;

public record RecipeTransferPacketC2S(ResourceLocation recipeId, boolean maxTransfer, boolean isFake) implements IPacketC2S
{
    public static final CustomPacketPayload.Type<RecipeTransferPacketC2S> TYPE = Confluence.createType("recipe_transfer");
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeTransferPacketC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, RecipeTransferPacketC2S::recipeId, (StreamCodec)ByteBufCodecs.BOOL, RecipeTransferPacketC2S::maxTransfer, (StreamCodec)ByteBufCodecs.BOOL, RecipeTransferPacketC2S::isFake, RecipeTransferPacketC2S::new);

    public CustomPacketPayload.Type<RecipeTransferPacketC2S> type() {
        return TYPE;
    }

    public void work(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu;
        Optional optional = player.server.getRecipeManager().byKey(this.recipeId);
        if (optional.isEmpty()) {
            return;
        }
        Recipe recipe = ((RecipeHolder)optional.get()).value();
        @Nullable EitherAmountRecipe4x recipe4x = RecipeTransferPacketC2S.getRecipe4x(EitherAmountRecipe4x.class, recipe, either -> new FakeAmountRecipe4x(player.registryAccess(), recipe, (Either<ShapedRecipePattern, NonNullList<Ingredient>>)either));
        if (recipe4x != null && (abstractContainerMenu = player.containerMenu) instanceof EitherAmountContainerMenu4x) {
            EitherAmountContainerMenu4x menu4x = (EitherAmountContainerMenu4x)abstractContainerMenu;
            menu4x.clearContainerNoUpdate((Player)player);
            List<Slot> slots = menu4x.slots.stream().filter(slot -> !slot.isFake() && slot.hasItem()).toList();
            recipe4x.either.ifLeft(pattern -> {
                NonNullList ingredients = pattern.ingredients();
                int width = pattern.width();
                int height = pattern.height();
                boolean symmetrical = pattern.symmetrical;
                for (int i = 0; i < height; ++i) {
                    block1: for (int j = 0; j < width; ++j) {
                        Ingredient ingredient = (Ingredient)ingredients.get(symmetrical ? width - j - 1 + i * width : j + i * width);
                        for (Slot slot : slots) {
                            if (!ingredient.test(slot.getItem())) continue;
                            ItemStack itemStack = player.getInventory().removeItem(slot.getSlotIndex(), AmountIngredient.getAmount((Ingredient)ingredient));
                            int index = j + i * width;
                            for (int k = 3; k > 0; --k) {
                                if (index < width * k) continue;
                                index += k * (4 - width);
                                break;
                            }
                            menu4x.getContainer().setItem(index, itemStack);
                            continue block1;
                        }
                    }
                }
            }).ifRight(ingredients -> {
                int index = 0;
                for (Ingredient ingredient : ingredients) {
                    for (Slot slot : slots) {
                        if (!ingredient.test(slot.getItem())) continue;
                        ItemStack itemStack = player.getInventory().removeItem(slot.getSlotIndex(), AmountIngredient.getAmount((Ingredient)ingredient));
                        menu4x.getContainer().setItem(index++, itemStack);
                    }
                }
            });
            menu4x.broadcastChanges();
        }
    }

    @Nullable
    public static <R extends EitherAmountRecipe4x<?>> R getRecipe4x(Class<R> clazz, Recipe<?> recipe, Function<Either<ShapedRecipePattern, NonNullList<Ingredient>>, R> factory) {
        EitherAmountRecipe4x recipe4x = null;
        if (clazz.isInstance(recipe)) {
            recipe4x = (EitherAmountRecipe4x)recipe;
        } else {
            Class clazz1 = recipe.getClass();
            if (clazz1 == ShapedRecipe.class) {
                recipe4x = (EitherAmountRecipe4x)factory.apply((Either<ShapedRecipePattern, NonNullList<Ingredient>>)Either.left((Object)((ShapedRecipe)recipe).pattern));
            } else if (clazz1 == ShapelessRecipe.class) {
                recipe4x = (EitherAmountRecipe4x)factory.apply((Either<ShapedRecipePattern, NonNullList<Ingredient>>)Either.right((Object)recipe.getIngredients()));
            }
        }
        return (R)recipe4x;
    }

    public static class FakeAmountRecipe4x
    extends EitherAmountRecipe4x<MenuRecipeInput> {
        private final Recipe<?> recipe;

        public FakeAmountRecipe4x(RegistryAccess registryAccess, Recipe<?> recipe, Either<ShapedRecipePattern, NonNullList<Ingredient>> either) {
            super(recipe.getResultItem((HolderLookup.Provider)registryAccess), either);
            this.recipe = recipe;
        }

        public String getGroup() {
            return this.recipe.getGroup();
        }

        public ItemStack getToastSymbol() {
            return this.recipe.getToastSymbol();
        }

        public RecipeSerializer<?> getSerializer() {
            return this.recipe.getSerializer();
        }

        public RecipeType<?> getType() {
            return this.recipe.getType();
        }
    }
}

