/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei.category;

import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.recipe.CookingPotRecipe;
import org.confluence.mod.integration.jei.ModJeiPlugin;
import org.jetbrains.annotations.Nullable;

public class CookingPotCategory
implements IRecipeCategory<RecipeHolder<CookingPotRecipe>> {
    public static final RecipeType<RecipeHolder<CookingPotRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)Confluence.asResource("cooking_pot"));
    private static final ResourceLocation BACKGROUND = Confluence.asResource("textures/gui/cooking_pot.png");
    private final IDrawable icon;

    public CookingPotCategory(IJeiHelpers jeiHelpers) {
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(FunctionalBlocks.COOKING_POT.toStack());
    }

    public RecipeType<RecipeHolder<CookingPotRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"title.confluence.cooking_pot");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 142;
    }

    public int getHeight() {
        return 49;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<CookingPotRecipe> recipe, IFocusGroup focuses) {
        int i = 0;
        int j = 0;
        for (Ingredient ingredient : ((CookingPotRecipe)recipe.value()).ingredients) {
            ModJeiPlugin.addInput(builder, 13 + i * 18, 7 + j * 18, ingredient);
            if (i == 1) {
                ++j;
                i = 0;
                continue;
            }
            ++i;
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 79, 1).addIngredients(((CookingPotRecipe)recipe.value()).getContainer());
        if (((CookingPotRecipe)recipe.value()).getHeatSource().blocks().isPresent()) {
            Ingredient heatSource = Ingredient.of(((Stream)((CookingPotRecipe)recipe.value()).getHeatSource().blocks().get().map(tag -> Streams.stream((Iterable)BuiltInRegistries.BLOCK.getTagOrEmpty(tag)), HolderSet::stream)).map(holder -> ((Block)holder.value()).asItem().getDefaultInstance()));
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 79, 32).addIngredients(heatSource)).addRichTooltipCallback((slotView, tooltip) -> ((CookingPotRecipe)recipe.value()).getHeatSource().properties().ifPresent(predicate -> {
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.jei.state_properties"));
                Iterator iterator = predicate.properties().iterator();
                while (iterator.hasNext()) {
                    StatePropertiesPredicate.PropertyMatcher property = (StatePropertiesPredicate.PropertyMatcher)iterator.next();
                    String prefix = "  " + property.name() + "=";
                    StatePropertiesPredicate.ValueMatcher valueMatcher = property.valueMatcher();
                    if (valueMatcher instanceof StatePropertiesPredicate.ExactMatcher) {
                        String value;
                        StatePropertiesPredicate.ExactMatcher $b$0 = (StatePropertiesPredicate.ExactMatcher)valueMatcher;
                        try {
                            String patt1$temp;
                            value = patt1$temp = $b$0.value();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        tooltip.add((FormattedText)Component.literal((String)(prefix + value)));
                        continue;
                    }
                    if (valueMatcher instanceof StatePropertiesPredicate.RangedMatcher) {
                        Optional maxValue;
                        Optional minValue;
                        StatePropertiesPredicate.RangedMatcher $b$2 = (StatePropertiesPredicate.RangedMatcher)valueMatcher;
                        {
                            Optional patt4$temp;
                            Optional patt3$temp;
                            minValue = patt3$temp = $b$2.minValue();
                            maxValue = patt4$temp = $b$2.maxValue();
                        }
                        tooltip.add((FormattedText)Component.literal((String)(prefix + "[" + minValue.orElse("") + "," + maxValue.orElse("") + "]")));
                        continue;
                    }
                    LibUtils.forMixin$Inject();
                }
                return;
            }));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 121, 16).addItemStack(((CookingPotRecipe)recipe.value()).getResultItem(null));
    }

    public void draw(RecipeHolder<CookingPotRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(BACKGROUND, 0, 0, 0.0f, 0.0f, 142, 49, 159, 49);
        if (((CookingPotRecipe)recipe.value()).getContainer().isEmpty()) {
            guiGraphics.blit(BACKGROUND, 79, 1, 143.0f, 0.0f, 16, 16, 159, 49);
        }
        if (((CookingPotRecipe)recipe.value()).getHeatSource().blocks().isEmpty()) {
            guiGraphics.blit(BACKGROUND, 79, 32, 143.0f, 33.0f, 16, 16, 159, 49);
        }
    }

    public ResourceLocation getRegistryName(RecipeHolder<CookingPotRecipe> recipe) {
        return Confluence.asResource(((CookingPotRecipe)recipe.value()).getGroup() + "/" + BuiltInRegistries.ITEM.getKey((Object)((CookingPotRecipe)recipe.value()).getResultItem(null).getItem()).getPath());
    }
}

