/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei.category;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawablesView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IScrollGridWidget;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.data.map.ExtractinatorData;
import org.confluence.mod.common.init.ModTags;

public class ExtractinatorCategory
implements IRecipeCategory<IngredientPair> {
    public static final RecipeType<IngredientPair> EXTRACTINATOR = new RecipeType(Confluence.asResource("extractinator"), IngredientPair.class);
    public static final RecipeType<IngredientPair> CHLOROPHYTE_EXTRACTINATOR = new RecipeType(Confluence.asResource("chlorophyte_extractinator"), IngredientPair.class);
    private static final IIngredientRenderer<ItemStack> INGREDIENT_RENDERER = new IIngredientRenderer<ItemStack>(){

        public void render(GuiGraphics guiGraphics, ItemStack ingredient) {
            RenderSystem.enableDepthTest();
            guiGraphics.renderFakeItem(ingredient, 0, 0);
            RenderSystem.disableBlend();
        }

        public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
            if (ingredient instanceof DataItemStack) {
                DataItemStack data = (DataItemStack)ingredient;
                Minecraft minecraft = Minecraft.getInstance();
                LocalPlayer player = minecraft.player;
                Item.TooltipContext tooltipContext = Item.TooltipContext.of((Level)minecraft.level);
                ArrayList lines = Lists.newArrayList((Iterable)ingredient.getTooltipLines(tooltipContext, (Player)player, tooltipFlag));
                lines.add(1, data.min == data.max ? Component.translatable((String)"tooltip.jei.count_exact", (Object[])new Object[]{data.min}) : Component.translatable((String)"tooltip.jei.count_range", (Object[])new Object[]{data.min, data.max}));
                lines.add(2, Component.translatable((String)"tooltip.jei.drop_chance", (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(data.chance * 100.0f)}));
                return lines;
            }
            return List.of();
        }
    };
    private final RecipeType<IngredientPair> recipeType;
    private final Component title;
    private final IDrawable icon;

    public ExtractinatorCategory(IJeiHelpers jeiHelpers, RecipeType<IngredientPair> recipeType, Block block) {
        this.recipeType = recipeType;
        this.title = block.getName();
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemLike((ItemLike)block);
    }

    public RecipeType<IngredientPair> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getHeight() {
        return 110;
    }

    public int getWidth() {
        return 142;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IngredientPair recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addInputSlot().addItemStack(recipe.ingredient)).setStandardSlotBackground();
        for (ExtractinatorData.Pool pool : recipe.data.pools()) {
            for (ExtractinatorData.Entry entry : pool.entries) {
                if (entry.isEmpty()) continue;
                ((IRecipeSlotBuilder)builder.addOutputSlot().addIngredientsUnsafe(List.of(new DataItemStack(entry.item, entry.minCount * pool.minRoll, entry.maxCount * pool.maxRoll, (float)entry.getWeight().asInt() / (float)pool.totalWeight)))).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, INGREDIENT_RENDERER).setStandardSlotBackground();
            }
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, IngredientPair recipe, IFocusGroup focuses) {
        IRecipeSlotDrawablesView recipeSlots = builder.getRecipeSlots();
        List outputSlots = recipeSlots.getSlots(RecipeIngredientRole.OUTPUT);
        IScrollGridWidget scrollGridWidget = builder.addScrollGridWidget(outputSlots, 7, 5);
        scrollGridWidget.setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
        IRecipeSlotDrawable inputSlot = (IRecipeSlotDrawable)recipeSlots.getSlots(RecipeIngredientRole.INPUT).getFirst();
        inputSlot.setPosition(scrollGridWidget.getScreenRectangle().position().x() + 1, 1);
    }

    public static List<IngredientPair> collectAll(DataMapType<Item, ExtractinatorData> type, RegistryAccess registryAccess) {
        HolderLookup.RegistryLookup lookup = registryAccess.lookupOrThrow(Registries.ITEM);
        IdentityHashMap<Item, ExtractinatorData> map = new IdentityHashMap<Item, ExtractinatorData>();
        ExtractinatorCategory.collectAny(map, type, (HolderLookup.RegistryLookup<Item>)lookup, (TagKey<Item>)Tags.Items.GRAVELS);
        ExtractinatorCategory.collectAny(map, type, (HolderLookup.RegistryLookup<Item>)lookup, ModTags.Items.DESERT_FOSSIL);
        ExtractinatorCategory.collectAny(map, type, (HolderLookup.RegistryLookup<Item>)lookup, ModTags.Items.JUNK);
        ExtractinatorCategory.collectAny(map, type, (HolderLookup.RegistryLookup<Item>)lookup, ModTags.Items.MARINE_GRAVEL);
        ExtractinatorCategory.collectAny(map, type, (HolderLookup.RegistryLookup<Item>)lookup, ModTags.Items.SILT_BLOCK);
        ExtractinatorCategory.collectAny(map, type, (HolderLookup.RegistryLookup<Item>)lookup, ModTags.Items.SLUSH);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)map.size());
        map.forEach((item, data) -> list.add(new IngredientPair(item.getDefaultInstance(), (ExtractinatorData)data)));
        return list;
    }

    private static void collectAny(Map<Item, ExtractinatorData> map, DataMapType<Item, ExtractinatorData> type, HolderLookup.RegistryLookup<Item> lookup, TagKey<Item> tagKey) {
        lookup.get(tagKey).ifPresent(holders -> holders.stream().forEach(itemHolder -> {
            ExtractinatorData data = (ExtractinatorData)itemHolder.getData(type);
            if (data != null) {
                map.put((Item)itemHolder.value(), data);
            }
        }));
    }

    public ResourceLocation getRegistryName(IngredientPair recipe) {
        return Confluence.asResource("extractinator/" + BuiltInRegistries.ITEM.getKey((Object)recipe.ingredient.getItem()).getPath());
    }

    public record IngredientPair(ItemStack ingredient, ExtractinatorData data) {
    }

    public static class DataItemStack
    extends ItemStack {
        public final int min;
        public final int max;
        public final float chance;

        public DataItemStack(ItemStack original, int min, int max, float chance) {
            super(original.getItemHolder(), original.getCount(), original.getComponentsPatch());
            this.min = min;
            this.max = max;
            this.chance = chance;
        }

        public DataItemStack(Item item, int min, int max, float chance) {
            super((ItemLike)item);
            this.min = min;
            this.max = max;
            this.chance = chance;
        }

        public ItemStack copy() {
            return new DataItemStack(this.getItem(), this.min, this.max, this.chance);
        }
    }
}

