/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei.category;

import java.util.Collection;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.recipe.SkyMillRecipe;
import org.confluence.mod.integration.jei.ModJeiPlugin;

public class SkyMillCategory
implements IRecipeCategory<RecipeHolder<SkyMillRecipe>> {
    public static final RecipeType<RecipeHolder<SkyMillRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)Confluence.asResource("sky_mill"));
    private static final ResourceLocation BACKGROUND = Confluence.asResource("textures/gui/sky_mill.png");
    private final IDrawable icon;

    public SkyMillCategory(IJeiHelpers jeiHelpers) {
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(FunctionalBlocks.SKY_MILL.toStack());
    }

    public RecipeType<RecipeHolder<SkyMillRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"title.confluence.sky_mill");
    }

    public int getWidth() {
        return 72;
    }

    public int getHeight() {
        return 72;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<SkyMillRecipe> recipe, IFocusGroup focusGroup) {
        NonNullList ingredients = ((SkyMillRecipe)recipe.value()).getIngredients();
        int size = ingredients.size();
        if (size == 1) {
            ModJeiPlugin.addInput(builder, 28, 51, (Ingredient)ingredients.getFirst());
        } else if (size == 2) {
            ModJeiPlugin.addInput(builder, 9, 32, (Ingredient)ingredients.getFirst());
            ModJeiPlugin.addInput(builder, 47, 32, (Ingredient)ingredients.get(1));
        } else {
            ModJeiPlugin.addInput(builder, 28, 51, (Ingredient)ingredients.getFirst());
            ModJeiPlugin.addInput(builder, 9, 32, (Ingredient)ingredients.get(1));
            ModJeiPlugin.addInput(builder, 47, 32, (Ingredient)ingredients.get(2));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 28, 8).addItemStack(((SkyMillRecipe)recipe.value()).getResultItem(null));
    }

    public void draw(RecipeHolder<SkyMillRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(BACKGROUND, 0, 0, 0.0f, 0.0f, 72, 72, 72, 72);
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<SkyMillRecipe> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        tooltip.addAll((Collection)((SkyMillRecipe)recipe.value()).getEnvironment().toDescriptions());
    }

    public ResourceLocation getRegistryName(RecipeHolder<SkyMillRecipe> recipe) {
        return Confluence.asResource(((SkyMillRecipe)recipe.value()).getGroup() + "/" + BuiltInRegistries.ITEM.getKey((Object)((SkyMillRecipe)recipe.value()).getResultItem(null).getItem()).getPath());
    }
}

