/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.recipe.SolidifierRecipe;
import org.confluence.mod.integration.jei.EitherRecipe4xHelper;
import org.confluence.mod.integration.jei.ModJeiPlugin;

public class SolidifierCategory
implements IRecipeCategory<RecipeHolder<SolidifierRecipe>> {
    public static final RecipeType<RecipeHolder<SolidifierRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)Confluence.asResource("solidifier"));
    private static final ResourceLocation BACKGROUND = Confluence.asResource("textures/gui/solidifier.png");
    private final IDrawable icon;
    private final EitherRecipe4xHelper helper;

    public SolidifierCategory(IJeiHelpers jeiHelpers) {
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(FunctionalBlocks.SOLIDIFIER.toStack());
        this.helper = new EitherRecipe4xHelper(jeiHelpers.getIngredientManager());
    }

    public RecipeType<RecipeHolder<SolidifierRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"title.confluence.solidifier");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 144;
    }

    public int getHeight() {
        return 80;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<SolidifierRecipe> recipe, IFocusGroup focuses) {
        ShapedRecipePattern pattern = (ShapedRecipePattern)((SolidifierRecipe)recipe.value()).either.orThrow();
        int width = pattern.width();
        int height = pattern.height();
        boolean symmetrical = pattern.symmetrical;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                if (symmetrical) {
                    ModJeiPlugin.addInput(builder, j * 18 + 6, i * 18 + 5, (Ingredient)((SolidifierRecipe)recipe.value()).ingredients.get(width - j - 1 + i * width));
                    continue;
                }
                ModJeiPlugin.addInput(builder, j * 18 + 6, i * 18 + 5, (Ingredient)((SolidifierRecipe)recipe.value()).ingredients.get(j + i * width));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 117, 33).addItemStack(((SolidifierRecipe)recipe.value()).getResultItem(null));
    }

    public void draw(RecipeHolder<SolidifierRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(BACKGROUND, 0, 0, 0.0f, 0.0f, 144, 80, 144, 80);
        if (mouseX >= 80.0 && mouseX <= 108.0 && mouseY >= 29.0 && mouseY <= 52.0) {
            this.helper.drawSummary(recipeSlotsView, guiGraphics);
        }
    }

    public ResourceLocation getRegistryName(RecipeHolder<SolidifierRecipe> recipe) {
        return Confluence.asResource(((SolidifierRecipe)recipe.value()).getGroup() + "/" + BuiltInRegistries.ITEM.getKey((Object)((SolidifierRecipe)recipe.value()).getResultItem(null).getItem()).getPath());
    }
}

