/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.prism_lib;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.util.TriState;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.component.prefix.PrefixComponent;
import org.confluence.mod.common.component.prefix.PrefixType;
import org.confluence.mod.util.PrefixUtils;
import org.jetbrains.annotations.Nullable;

public class PrismLibHelper {
    public static final boolean IS_LOADED = ModList.get().isLoaded("prism");
    public static final boolean LEGENDARY_TOOLTIPS = ModList.get().isLoaded("legendarytooltips");
    private static TriState renderItemModel = TriState.DEFAULT;

    @Nullable
    public static TextColor getRarityColor(ItemStack itemStack) {
        ModRarity rarity = ModRarity.getModRarity((ItemStack)itemStack, (boolean)false);
        return rarity == null ? null : rarity.asTextColor();
    }

    @Nullable
    public static Pair<Supplier<Integer>, Supplier<Integer>> getSpecialColor(ItemStack itemStack) {
        ModRarity rarity = ModRarity.getModRarity((ItemStack)itemStack, (boolean)false);
        if (rarity != null && rarity.isSpecial()) {
            Supplier<Integer> supplier = () -> ((ModRarity)rarity).color();
            return new Pair(supplier, supplier);
        }
        return null;
    }

    public static boolean shouldDisableAltImageTooltip() {
        if (LEGENDARY_TOOLTIPS) {
            if (renderItemModel.isDefault()) {
                try {
                    Class<?> config = PrismLibHelper.class.getClassLoader().loadClass("com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig");
                    Object instance = config.getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                    Field renderItemModel = config.getDeclaredField("renderItemModel");
                    renderItemModel.setAccessible(true);
                    PrismLibHelper.renderItemModel = ((Enum)((Supplier)renderItemModel.get(instance)).get()).ordinal() == 0 ? TriState.FALSE : TriState.TRUE;
                }
                catch (Exception e) {
                    renderItemModel = TriState.FALSE;
                }
            }
            return renderItemModel.isTrue();
        }
        return false;
    }

    public static boolean shouldSkipOriginalPrefixGather(ItemStack itemStack, List<Either<FormattedText, TooltipComponent>> tooltipElements) {
        if (LEGENDARY_TOOLTIPS) {
            Object t;
            if (tooltipElements.size() < 2) {
                return false;
            }
            Optional displayName = tooltipElements.get(1).left();
            if (displayName.isPresent() && (t = displayName.get()) instanceof Component) {
                Component component = (Component)t;
                PrefixComponent prefix = PrefixUtils.getPrefix(itemStack);
                if (prefix != null && prefix.type() != PrefixType.UNKNOWN) {
                    tooltipElements.set(1, (Either<FormattedText, TooltipComponent>)Either.left((Object)prefix.getName().setStyle(component.getStyle()).append((Component)Component.translatable((String)"confluence.prefix_separator")).append(component)));
                    return true;
                }
            }
        }
        return false;
    }
}

