/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.sodium.dynamiclights;

import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;
import org.confluence.mod.client.handler.ClientPacketHandler;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.terra_curio.api.primitive.IntegerValue;
import org.confluence.terraentity.init.entity.TEProjectileEntities;

public class SodiumDynamicLightsHelper {
    public static final boolean IS_LOADED = ModList.get().isLoaded("sodiumdynamiclights");

    public static void registerDynamicLight() {
        if (IS_LOADED) {
            DynamicLightHandlers.registerDynamicLightHandler((EntityType)((EntityType)ModEntities.ARROW_PROJECTILE.get()), entity -> entity.modify.getLuminance());
            DynamicLightHandlers.registerDynamicLightHandler((EntityType)((EntityType)ModEntities.CURSED_FLAMES_PROJECTILE.get()), entity -> 15);
            DynamicLightHandlers.registerDynamicLightHandler((EntityType)((EntityType)ModEntities.STAR_CANNON_BULLET.get()), entity -> 10);
            DynamicLightHandlers.registerDynamicLightHandler((EntityType)((EntityType)TEProjectileEntities.BOOMERANG_PROJECTILE.get()), entity -> entity.getModifier().luminance);
        }
    }

    public static int getLuminance(Entity entity, int returnValue) {
        int luminance = 0;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living instanceof Player) {
                Player player = (Player)living;
                luminance = IntegerValue.abxMax((int)luminance, (int)ClientPacketHandler.getLuminance(player));
            }
            if (living.hasEffect(ModEffects.SHINE)) {
                luminance = IntegerValue.abxMax((int)luminance, (int)10);
            }
        }
        return IntegerValue.abxMax((int)luminance, (int)returnValue);
    }
}

