/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity;

import com.google.gson.JsonElement;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.confluence.mod.Confluence;
import org.confluence.mod.util.ModUtils;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.terraentity.entity.animal.SimpleVariantAnimal;

public final class TEHelper {
    public static void processRecipes(Map<ResourceLocation, JsonElement> objectMap) {
        objectMap.entrySet().removeIf(entry -> "terra_entity".equals(((ResourceLocation)entry.getKey()).getNamespace()));
    }

    public static void redirectLootTable() {
        for (Map.Entry entry : BuiltInRegistries.ENTITY_TYPE.entrySet()) {
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            if (!"terra_entity".equals(id.getNamespace())) continue;
            ((EntityType)entry.getValue()).lootTable = Confluence.asResourceKey(Registries.LOOT_TABLE, "entities/terra_entity/" + id.getPath());
        }
    }

    public static boolean wormSpawnRules(EntityType<SimpleVariantAnimal> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!(level instanceof Level)) {
            return false;
        }
        Level level1 = (Level)level;
        int y = pos.getY();
        int surfaceY = OverworldUtils.getSurfaceY();
        if (y > surfaceY && y < OverworldUtils.getSpaceY() && ModUtils.isRainingAt(level1, pos)) {
            return true;
        }
        return y > OverworldUtils.getUndergroundY() && y < surfaceY;
    }

    public static void finalizeWormSpawn(SimpleVariantAnimal worm) {
    }
}

