/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock;

import com.mojang.serialization.MapCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.client.handler.bestiary.ClientBestiary;
import org.confluence.mod.common.data.saved.Bestiary;
import org.confluence.mod.integration.terra_entity.init.ModTradeLockProviderTypes;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.registries.npc_trade_lock.TradeLockProvider;

public record BestiaryUnlockedCountLock(int count) implements ITradeLock
{
    public static final MapCodec<BestiaryUnlockedCountLock> CODEC = ExtraCodecs.POSITIVE_INT.fieldOf("count").xmap(BestiaryUnlockedCountLock::new, BestiaryUnlockedCountLock::count);

    public boolean canTrade(Player player, ITradeHolder npc, int index) {
        if (player.isLocalPlayer()) {
            return ClientBestiary.getInstance().getUnlockedCount() >= this.count;
        }
        return Bestiary.INSTANCE.getUnlockedCount() >= this.count;
    }

    public TradeLockProvider getCodec() {
        return ModTradeLockProviderTypes.BESTIARY_UNLOCKED_COUNT_LOCK.get();
    }

    @Override
    public String toString() {
        return "BestiaryUnlockedCountLock{count=" + this.count + "}";
    }

    @Override
    public boolean equals(Object o) {
        boolean bl;
        block4: {
            block2: {
                block3: {
                    if (this == o) break block3;
                    if (!(o instanceof BestiaryUnlockedCountLock)) break block2;
                    BestiaryUnlockedCountLock bestiaryUnlockedCountLock = (BestiaryUnlockedCountLock)o;
                    try {
                        int n;
                        int count1 = n = bestiaryUnlockedCountLock.count();
                        if (count1 != this.count) break block2;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this.count;
    }
}

