/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.confluence.mod.integration.terra_entity.init.ModTradeLockProviderTypes;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.registries.npc_trade_lock.TradeLockProvider;

public record ConditionsLock(List<ICondition> conditions) implements ITradeLock
{
    public static final MapCodec<ConditionsLock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ICondition.LIST_CODEC.fieldOf("conditions").forGetter(ConditionsLock::conditions)).apply((Applicative)instance, ConditionsLock::new));

    public ConditionsLock(ICondition ... conditions) {
        this(Arrays.stream(conditions).toList());
    }

    public boolean canTrade(Player player, ITradeHolder npc, int index) {
        return this.conditions.stream().allMatch(condition -> condition.test(ICondition.IContext.TAGS_INVALID));
    }

    public TradeLockProvider getCodec() {
        return ModTradeLockProviderTypes.CONDITIONS_LOCK.get();
    }
}

