/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.confluence.mod.integration.terra_entity.init.ModTradeLockProviderTypes;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.registries.npc_trade_lock.TradeLockProvider;

public record DimensionLock(ResourceKey<Level> dimension) implements ITradeLock
{
    public static final MapCodec<DimensionLock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(DimensionLock::dimension)).apply((Applicative)instance, DimensionLock::new));

    public boolean canTrade(Player player, ITradeHolder npc, int index) {
        return npc.level().dimension() == this.dimension;
    }

    public TradeLockProvider getCodec() {
        return ModTradeLockProviderTypes.DIMENSION_LOCK.get();
    }

    @Override
    public boolean equals(Object o) {
        boolean bl;
        block4: {
            block2: {
                block3: {
                    if (o == this) break block3;
                    if (!(o instanceof DimensionLock)) break block2;
                    DimensionLock dimensionLock = (DimensionLock)o;
                    try {
                        ResourceKey<Level> resourceKey;
                        ResourceKey<Level> dimension1 = resourceKey = dimensionLock.dimension();
                        if (this.dimension != dimension1) break block2;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this.dimension.location().hashCode();
    }
}

