/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.integration.terra_entity.init.ModTradeLockProviderTypes;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.registries.npc_trade_lock.TradeLockProvider;

public record PositionLock(MinMaxBounds.Ints x, MinMaxBounds.Ints y, MinMaxBounds.Ints z) implements ITradeLock
{
    public static final MapCodec<PositionLock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinMaxBounds.Ints.CODEC.optionalFieldOf("x", (Object)MinMaxBounds.Ints.ANY).forGetter(PositionLock::x), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("y", (Object)MinMaxBounds.Ints.ANY).forGetter(PositionLock::y), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("z", (Object)MinMaxBounds.Ints.ANY).forGetter(PositionLock::z)).apply((Applicative)instance, PositionLock::new));

    public boolean canTrade(Player player, ITradeHolder npc, int index) {
        BlockPos pos = npc.blockPosition();
        return this.x.matches(pos.getX()) && this.y.matches(pos.getY()) && this.z.matches(pos.getZ());
    }

    public TradeLockProvider getCodec() {
        return ModTradeLockProviderTypes.POSITION_LOCK.get();
    }

    public static PositionLock ofX(MinMaxBounds.Ints x) {
        return new PositionLock(x, MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY);
    }

    public static PositionLock ofY(MinMaxBounds.Ints y) {
        return new PositionLock(MinMaxBounds.Ints.ANY, y, MinMaxBounds.Ints.ANY);
    }

    public static PositionLock ofZ(MinMaxBounds.Ints z) {
        return new PositionLock(MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, z);
    }
}

