/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock.drawer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.confluence.lib.common.recipe.EnvironmentLevelAccess;
import org.confluence.mod.Confluence;
import org.confluence.mod.integration.terra_entity.npc_trade_lock.EnvironmentLock;
import org.confluence.terraentity.TerraEntity;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.api.npc.trade.TradeLockRecipeDrawer;

public class EnvironmentLockRecipeDrawer
extends TradeLockRecipeDrawer {
    private static final ResourceLocation GRAVEYARD_SPRITE = Confluence.asResource("shop_lock/environment_graveyard");
    private static final ResourceLocation BIOME_SPRITE = TerraEntity.space((String)"shop_lock/biome");

    public int drawRecipe(ITradeLock lock, GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (!(lock instanceof EnvironmentLock)) {
            return y;
        }
        EnvironmentLock environmentLock = (EnvironmentLock)lock;
        int size = this.getRecipeSize();
        if (environmentLock.environment().graveyard()) {
            guiGraphics.blitSprite(GRAVEYARD_SPRITE, x, y, size, size);
            this.drawTooltip(guiGraphics, x, y, size, size, mouseX, mouseY, I18n.get((String)"bestiary.confluence.filter.graveyard.title", (Object[])new Object[0]));
            x += size;
        }
        if (environmentLock.environment().biome().isPresent()) {
            ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
            tooltipLines.add(Component.translatable((String)"terra_entity.trade_lock.drawer.biome.title"));
            for (Holder biome : (HolderSet)environmentLock.environment().biome().get()) {
                guiGraphics.blitSprite(BIOME_SPRITE, x, y, size, size);
                ResourceKey biomeKey = biome.getKey();
                ResourceLocation biomeLocation = biomeKey == null ? null : biomeKey.location();
                String biomeName = biomeLocation == null ? "[unknown biome]" : biomeLocation.toLanguageKey(Registries.BIOME.location().getPath());
                tooltipLines.add(Component.translatable((String)biomeName));
            }
            this.drawTooltip(guiGraphics, x, y, size, size, mouseX, mouseY, tooltipLines);
            x += size;
        }
        if (environmentLock.environment().block().isPresent()) {
            String groupTitle;
            Object icon;
            ArrayList<Component> lines;
            if (((EnvironmentLevelAccess.SearchContext)environmentLock.environment().block().get()).blocks().isPresent()) {
                lines = new ArrayList<Component>();
                for (Holder block : (HolderSet)((EnvironmentLevelAccess.SearchContext)environmentLock.environment().block().get()).blocks().get()) {
                    lines.add((Component)((Block)block.value()).getName());
                }
                icon = "shop_lock/environment_block";
                groupTitle = "confluence.trade_lock.drawer.environment.block";
                x = this.drawEnvironmentGroup(guiGraphics, x, y, mouseX, mouseY, environmentLock, (List<Component>)lines, (String)icon, groupTitle, size);
            }
            if (((EnvironmentLevelAccess.SearchContext)environmentLock.environment().block().get()).fluids().isPresent()) {
                lines = new ArrayList();
                for (Holder block : (HolderSet)((EnvironmentLevelAccess.SearchContext)environmentLock.environment().block().get()).fluids().get()) {
                    String liquid = BuiltInRegistries.FLUID.getKey((Object)((Fluid)block.value())).toLanguageKey(Registries.FLUID.location().getPath());
                    lines.add((Component)Component.translatable((String)liquid));
                }
                icon = "shop_lock/environment_fluid";
                groupTitle = "confluence.trade_lock.drawer.environment.fluid";
                x = this.drawEnvironmentGroup(guiGraphics, x, y, mouseX, mouseY, environmentLock, lines, (String)icon, groupTitle, size);
            }
            if (!((EnvironmentLevelAccess.SearchContext)environmentLock.environment().block().get()).statePredicates().isEmpty()) {
                lines = new ArrayList();
                for (StatePropertiesPredicate statePredicate : ((EnvironmentLevelAccess.SearchContext)environmentLock.environment().block().get()).statePredicates()) {
                    String properties = EnvironmentLockRecipeDrawer.getPredicateProperties(statePredicate);
                    lines.add((Component)Component.literal((String)properties));
                }
                icon = "shop_lock/environment_block_state";
                groupTitle = "confluence.trade_lock.drawer.environment.block_state_predicate";
                x = this.drawEnvironmentGroup(guiGraphics, x, y, mouseX, mouseY, environmentLock, lines, (String)icon, groupTitle, size);
            }
        }
        return y + size;
    }

    private int drawEnvironmentGroup(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, EnvironmentLock environmentLock, List<Component> tooltipLines2, String icon, String groupTitle, int size) {
        ArrayList<Object> tooltipLines = new ArrayList<Object>();
        tooltipLines.add(Component.translatable((String)"confluence.trade_lock.drawer.environment.radius", (Object[])new Object[]{((EnvironmentLevelAccess.SearchContext)environmentLock.environment().block().get()).inflate()}));
        tooltipLines.add(Component.translatable((String)groupTitle).append(":"));
        tooltipLines.addAll(tooltipLines2);
        guiGraphics.blitSprite(Confluence.asResource(icon), x, y, size, size);
        this.drawTooltip(guiGraphics, x, y, size, size, mouseX, mouseY, tooltipLines);
        return x + size;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPredicateProperties(StatePropertiesPredicate statePredicate) {
        StringBuilder properties = new StringBuilder();
        Iterator iterator = statePredicate.properties().iterator();
        while (true) {
            Object object;
            if (!iterator.hasNext()) {
                String propertiesString = properties.toString();
                return propertiesString.substring(0, Math.max(0, propertiesString.length() - 1));
            }
            StatePropertiesPredicate.PropertyMatcher entry = (StatePropertiesPredicate.PropertyMatcher)iterator.next();
            String name = entry.name();
            StatePropertiesPredicate.ValueMatcher valueMatcher = entry.valueMatcher();
            if (valueMatcher instanceof StatePropertiesPredicate.ExactMatcher) {
                StatePropertiesPredicate.ExactMatcher exactMatcher = (StatePropertiesPredicate.ExactMatcher)valueMatcher;
                try {
                    object = exactMatcher.value();
                    String value = object;
                    properties.append(name).append("=").append(value).append(",");
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            if (!(valueMatcher instanceof StatePropertiesPredicate.RangedMatcher)) continue;
            StatePropertiesPredicate.RangedMatcher rangedMatcher = (StatePropertiesPredicate.RangedMatcher)valueMatcher;
            {
                Object minValue = object = rangedMatcher.minValue();
                Object maxValue = object = rangedMatcher.maxValue();
                properties.append(name).append("=").append(minValue).append("..").append(maxValue).append(",");
            }
        }
    }
}

