/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock.drawer;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.data.saved.MoonPhase;
import org.confluence.mod.integration.terra_entity.npc_trade_lock.MoonPhaseLock;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.api.npc.trade.TradeLockRecipeDrawer;

public class MoonPhaseLockRecipeDrawer
extends TradeLockRecipeDrawer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int drawRecipe(ITradeLock lock, GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        List<MoonPhase> moonPhases;
        if (!(lock instanceof MoonPhaseLock)) return y;
        MoonPhaseLock moonPhaseLock = (MoonPhaseLock)lock;
        try {
            List<MoonPhase> list = moonPhaseLock.moonPhases();
            moonPhases = list;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        int size = this.getRecipeSize();
        for (MoonPhase moonPhase : moonPhases) {
            String moonPhaseTexture = this.getMoonPhaseTexture(moonPhase);
            guiGraphics.blit(Confluence.asResource("textures/environment/specific_moon/tr_" + moonPhaseTexture), x, y, size, size, 0.0f, 0.0f, 50, 50, 50, 50);
            this.drawTooltip(guiGraphics, x, y, size, size, mouseX, mouseY, I18n.get((String)"confluence.trade_lock.drawer.moon_phase.title", (Object[])new Object[0]) + ": " + moonPhase.getSerializedName());
            x += size;
        }
        return y + size;
    }

    private String getMoonPhaseTexture(MoonPhase moonPhase) {
        return switch (moonPhase) {
            default -> throw new MatchException(null, null);
            case MoonPhase.FULL_MOON -> "full_moon.png";
            case MoonPhase.WANING_GIBBOUS -> "waning_gibbous.png";
            case MoonPhase.THIRD_QUARTER -> "third_quarter.png";
            case MoonPhase.WAXING_CRESCENT -> "waxing_crescent.png";
            case MoonPhase.NEW_MOON -> "new_moon.png";
            case MoonPhase.WANING_CRESCENT -> "waning_crescent.png";
            case MoonPhase.FIRST_QUARTER -> "first_quarter.png";
            case MoonPhase.WAXING_GIBBOUS -> "waxing_gibbous.png";
        };
    }
}

