/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.trail;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.confluence.mod.client.event.ModClientSetups;
import org.confluence.mod.common.entity.projectile.sword.NightEdgeProjectile;
import org.confluence.terraentity.api.entity.trail.ITrail;
import org.confluence.terraentity.entity.util.trail.PositionPoseProperties;
import org.confluence.terraentity.entity.util.trail.TrailProperties;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TerraSwordTrail
implements ITrail<NightEdgeProjectile> {
    TrailProperties properties;
    public Queue<PositionPoseProperties> trailsQueue;

    public TerraSwordTrail(float size, float widthScale, int color) {
        this.properties = new TrailProperties(size, widthScale, 5.0f, color, color);
        this.trailsQueue = new LinkedList<PositionPoseProperties>();
    }

    public void generateTrail(NightEdgeProjectile holder, int ticks) {
        if (this.trailsQueue.size() >= 100) {
            this.trailsQueue.poll();
        }
        if (holder.lifetime - ticks <= 0) {
            this.trailsQueue.poll();
        } else if (ticks > 1 && holder.getOwner() != null) {
            this.trailsQueue.add(new PositionPoseProperties(holder.position().subtract(holder.getOwner().position()), holder.getXRot() * ((float)Math.PI / 180), holder.getYRot() * ((float)Math.PI / 180)));
        }
    }

    public void generateTrail(NightEdgeProjectile holder, int ticks, Vec3 entityPos, float partialTicks) {
        if (this.trailsQueue.size() >= 100) {
            this.trailsQueue.poll();
        }
        if (holder.lifetime - ticks <= 4) {
            this.trailsQueue.poll();
        } else {
            float lerpRotx = Mth.lerp((float)partialTicks, (float)holder.xRotO, (float)holder.getXRot());
            float lerpRoty = Mth.lerp((float)partialTicks, (float)holder.yRotO, (float)holder.getYRot());
            if (ticks > 1 && holder.getOwner() != null) {
                this.trailsQueue.add(new PositionPoseProperties(entityPos, lerpRotx * ((float)Math.PI / 180), lerpRoty * ((float)Math.PI / 180)));
            }
        }
    }

    public TrailProperties getTrailProperties() {
        return this.properties;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTrail(NightEdgeProjectile holder, Vec3 entityPos, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.actualRender(holder, this.trailsQueue, entityPos, poseStack, bufferSource, packedLight, ModClientSetups.TERRA_SWORD_RENDER_TYPE);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void actualRender(NightEdgeProjectile holder, Queue<PositionPoseProperties> trailsQueue, Vec3 entityPos, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, RenderType renderType) {
        Iterator trails = trailsQueue.iterator();
        int size = trailsQueue.size();
        TrailProperties properties = this.getTrailProperties();
        if (!trails.hasNext()) {
            return;
        }
        poseStack.pushPose();
        Matrix4f matrix4f = poseStack.last().pose();
        VertexConsumer buffer = bufferSource.getBuffer(renderType);
        int color = 0xFFFFFF;
        int red = FastColor.ARGB32.red((int)color);
        int green = FastColor.ARGB32.green((int)color);
        int blue = FastColor.ARGB32.blue((int)color);
        int colorFrom = 0xFFFFFF;
        int redFrom = FastColor.ARGB32.red((int)colorFrom);
        int greenFrom = FastColor.ARGB32.green((int)colorFrom);
        int blueFrom = FastColor.ARGB32.blue((int)colorFrom);
        int lastColor = FastColor.ARGB32.color((int)0, (int)red, (int)green, (int)blue);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)1, (int)1);
        Vec3 o0 = null;
        Vec3 o1 = null;
        Vec3 o2 = null;
        Vec3 o3 = null;
        float _progress = 0.0f;
        PositionPoseProperties p = (PositionPoseProperties)trails.next();
        Vec3 lastPos = p.position.subtract(entityPos);
        int i = 0;
        while (trails.hasNext()) {
            Vec3 right0;
            Vec3 left0;
            Vec3 pos0 = lastPos;
            p = (PositionPoseProperties)trails.next();
            Vec3 pos1 = p.position.subtract(entityPos);
            float progress = (float)i / (float)size;
            float width = properties.widthScale() * progress;
            int alpha = (int)(200.0f * progress);
            if (!trails.hasNext()) {
                alpha = 20;
            }
            int lerpRed = (int)Mth.lerp((float)progress, (float)red, (float)redFrom);
            int lerpGreen = (int)Mth.lerp((float)progress, (float)green, (float)greenFrom);
            int lerpBlue = (int)Mth.lerp((float)progress, (float)blue, (float)blueFrom);
            int argb = FastColor.ARGB32.color((int)alpha, (int)lerpRed, (int)lerpGreen, (int)lerpBlue);
            float rotx = p.xrot;
            float roty = -p.yrot;
            Vector3f d = new Vector3f(0.0f, 0.0f, 1.0f);
            new Quaternionf().rotateY(roty).rotateX(rotx).transform(d);
            Vec3 side = new Vec3(d.normalize());
            Vec3 left11 = pos1.add(side.scale((double)(width * properties.fadeWidthFactor())));
            Vec3 right11 = pos1.add(side.scale((double)(-width * properties.fadeWidthFactor())));
            Vec3 left1 = pos1.add(side.scale((double)(width * 5.0f)));
            Vec3 right1 = pos1.add(side.scale((double)(-width * 5.0f)));
            if (o0 != null) {
                left0 = o0;
                right0 = o1;
                left00 = o2;
                right00 = o3;
            } else {
                left0 = pos0.add(side.scale((double)width));
                right0 = pos0.add(side.scale((double)(-width)));
                left00 = pos0.add(side.scale((double)width));
                right00 = pos0.add(side.scale((double)(-width)));
            }
            ITrail.addVertex((VertexConsumer)buffer, (Matrix4f)matrix4f, (Vec3)left0, (int)lastColor).setUv(0.0f, _progress).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f).setUv2(packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF).setOverlay(OverlayTexture.NO_OVERLAY);
            ITrail.addVertex((VertexConsumer)buffer, (Matrix4f)matrix4f, (Vec3)right0, (int)lastColor).setUv(1.0f, _progress).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f).setUv2(packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF).setOverlay(OverlayTexture.NO_OVERLAY);
            ITrail.addVertex((VertexConsumer)buffer, (Matrix4f)matrix4f, (Vec3)right1, (int)argb).setUv(1.0f, progress).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f).setUv2(packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF).setOverlay(OverlayTexture.NO_OVERLAY);
            ITrail.addVertex((VertexConsumer)buffer, (Matrix4f)matrix4f, (Vec3)left1, (int)argb).setUv(0.0f, progress).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f).setUv2(packedLight & 0xFFFF, packedLight >> 16 & 0xFFFF).setOverlay(OverlayTexture.NO_OVERLAY);
            o0 = left1;
            o1 = right1;
            o2 = left11;
            o3 = right11;
            lastPos = pos1;
            ++i;
            lastColor = argb;
            _progress = progress;
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }
}

