/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.waystones;

import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PylonBlock
extends WaystoneBlock {
    private static final VoxelShape SHAPE = PylonBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public final int id;
    private final Survive survive;

    public PylonBlock(int id, BlockBehaviour.Properties properties, Survive survive) {
        super(properties);
        this.id = id;
        this.survive = survive;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return super.canSurvive(state, world, pos) && this.survive.canSurvive(world, pos, (Holder<Biome>)world.getBiome(pos));
    }

    @NotNull
    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    @FunctionalInterface
    public static interface Survive {
        public boolean canSurvive(LevelReader var1, BlockPos var2, Holder<Biome> var3);
    }

    public static class BEntity
    extends WaystoneBlockEntity
    implements GeoBlockEntity {
        private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        private final ResourceLocation waystoneType;
        public final boolean isBase;

        public BEntity(BlockPos blockPos, BlockState blockState) {
            super(blockPos, blockState);
            this.waystoneType = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock());
            this.isBase = blockState.getValue((Property)WaystoneBlock.HALF) == DoubleBlockHalf.LOWER;
        }

        protected ResourceLocation getWaystoneType() {
            return this.waystoneType;
        }

        public Component getName() {
            return Component.translatable((String)"container.confluence.pylon");
        }

        public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
            controllers.add(new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.new"))));
        }

        public AnimatableInstanceCache getAnimatableInstanceCache() {
            return this.cache;
        }
    }
}

