/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CropBlock.class})
public abstract class CropBlockMixin {
    @Shadow
    @Final
    public static IntegerProperty AGE;
    @Shadow
    @Final
    public static int MAX_AGE;

    @Inject(method={"entityInside"}, at={@At(value="TAIL")})
    private void explode(BlockState state, Level level, BlockPos pos, Entity entity, CallbackInfo ci) {
        ServerLevel serverLevel;
        if (state.is(Blocks.POTATOES) && (Integer)state.getValue((Property)AGE) == MAX_AGE && level instanceof ServerLevel && ModSecretSeeds.NO_TRAPS.match(serverLevel = (ServerLevel)level)) {
            level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2.5f, false, Level.ExplosionInteraction.BLOCK);
        }
    }
}

