/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.client;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.confluence.mod.mixed.ILevelRenderer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LevelRenderer.class}, priority=900)
public abstract class LevelRendererMixin
implements ILevelRenderer {
    @Shadow
    @Nullable
    private ViewArea viewArea;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    public abstract void needsUpdate();

    @Override
    public void confluence$rebuildAllChunks() {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        if (IS_SODIUM_LOADED) {
            this.confluence$rebuildAllChunksSodium(player);
        } else if (this.viewArea != null) {
            for (SectionRenderDispatcher.RenderSection chunk : this.viewArea.sections) {
                chunk.setDirty(true);
            }
            this.needsUpdate();
        }
    }

    @Unique
    private void confluence$rebuildAllChunksSodium(LocalPlayer player) {
        ChunkPos chunkPos = player.chunkPosition();
        int viewDistance = (Integer)this.minecraft.options.renderDistance().get();
        Level level = player.level();
        int startY = level.getMinSection();
        int endY = level.getMaxSection();
        for (int x = -viewDistance; x < viewDistance; ++x) {
            int cx = chunkPos.x + x;
            for (int z = -viewDistance; z < viewDistance; ++z) {
                int cz = chunkPos.z + z;
                for (int y = startY; y <= endY; ++y) {
                    ILevelRenderer.scheduleRebuildForChunk(cx, y, cz);
                }
            }
        }
    }
}

