/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.util.Pair;
import java.util.OptionalLong;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.world.level.levelgen.WorldOptions;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.worldgen.secret_seed.SecretSeed;
import org.confluence.mod.mixed.IWorldOptions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={WorldCreationUiState.class})
public abstract class WorldCreationUiStateMixin {
    @Shadow
    public abstract String getSeed();

    @WrapOperation(method={"lambda$setSeed$2"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/WorldOptions;withSeed(Ljava/util/OptionalLong;)Lnet/minecraft/world/level/levelgen/WorldOptions;")})
    private WorldOptions checkSecretSeed(WorldOptions instance, OptionalLong seed, Operation<WorldOptions> original) {
        Pair<SecretSeed, WorldOptions> tuple;
        instance = IWorldOptions.of(instance).confluence$copyWithoutSecretFlag();
        if (!this.getSeed().isEmpty() && (tuple = ModSecretSeeds.matchSeed(this.getSeed(), instance)).getFirst() != null) {
            return (WorldOptions)tuple.getSecond();
        }
        return (WorldOptions)original.call(new Object[]{instance, seed});
    }
}

