/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.confluence.mod.mixed.IWorldOptions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldSelectionList.WorldListEntry.class})
public abstract class WorldSelectionList$WorldListEntryMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private long confluence$secretFlag;
    @Unique
    private ResourceLocation confluence$worldIcon;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void loadSecretFlag(WorldSelectionList this$0, WorldSelectionList worldSelectionList, LevelSummary summary, CallbackInfo ci) {
        try {
            LevelStorageSource.LevelStorageAccess levelStorageAccess = this.minecraft.getLevelSource().validateAndCreateAccess(summary.getLevelId());
            this.confluence$secretFlag = levelStorageAccess.getDataTag().get("WorldGenSettings").orElseEmptyMap().get("secret_flag").asLong(0L);
            levelStorageAccess.safeClose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderSecretFlagIcon(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick, CallbackInfo ci) {
        if (this.confluence$worldIcon == null) {
            this.confluence$worldIcon = IWorldOptions.getWorldIcon(this.confluence$secretFlag);
        }
        guiGraphics.blitSprite(this.confluence$worldIcon, 32, 32, 0, 0, left, top - 1, 32, 32);
    }
}

