/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.entity;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.mixed.IAbstractArrow;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Projectile
implements IAbstractArrow {
    @Unique
    private static final byte[] confluence$dataIds = new byte[]{0};
    @Unique
    private boolean confluence$fromShortBow = false;
    @Unique
    private boolean confluence$isDisappearingOnGround;
    @Unique
    private boolean confluence$damageNotAffectedBySpeedBonus;

    private AbstractArrowMixin(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public boolean confluence$isShootFromShortBow() {
        return this.confluence$fromShortBow;
    }

    @Override
    public void confluence$setShootFromShortBow(boolean is) {
        this.confluence$setData((byte)0, is);
    }

    public void confluence$setData(byte dataId, Object o) {
        IAbstractArrow.super.confluence$setData(dataId, o);
        this.confluence$fromShortBow = (Boolean)o;
    }

    public Object confluence$getData(byte dataId) {
        return this.confluence$fromShortBow;
    }

    public byte[] confluence$getAllDataId() {
        return confluence$dataIds;
    }

    @Override
    public boolean confluence$isDamageNotAffectedBySpeedBonus() {
        return this.confluence$damageNotAffectedBySpeedBonus || this.confluence$isShootFromShortBow();
    }

    @Override
    public void confluence$setDamageNotAffectedBySpeedBonus(boolean is) {
        this.confluence$damageNotAffectedBySpeedBonus = is;
    }

    @Override
    public boolean confluence$isDisappearingOnGround() {
        return this.confluence$isDisappearingOnGround;
    }

    @Override
    public void confluence$setDisappearingOnGround(boolean confluence$isDisappearingOnGround) {
        this.confluence$isDisappearingOnGround = confluence$isDisappearingOnGround;
    }

    @ModifyVariable(method={"shoot"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float boost(float velocity) {
        LivingEntity living;
        Entity entity = ((AbstractArrow)this.confluence$self()).getOwner();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(ModEffects.ARCHERY)) {
            return velocity * 1.2f;
        }
        return velocity;
    }

    @ModifyExpressionValue(method={"onHitEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;length()D")})
    private double shortBowLength(double original) {
        return this.confluence$isDamageNotAffectedBySpeedBonus() ? 1.0 : original;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addShortBow(CompoundTag pCompound, CallbackInfo ci) {
        pCompound.putBoolean("confluence:from_short_bow", this.confluence$isShootFromShortBow());
        pCompound.putBoolean("confluence:damage_not_affected_by_speed_bonus", this.confluence$damageNotAffectedBySpeedBonus);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readShortBow(CompoundTag pCompound, CallbackInfo ci) {
        this.confluence$setShootFromShortBow(pCompound.getBoolean("confluence:from_short_bow"));
        this.confluence$damageNotAffectedBySpeedBonus = pCompound.getBoolean("confluence:damage_not_affected_by_speed_bonus");
    }

    @WrapMethod(method={"onHitBlock"})
    private void onHitBlock(BlockHitResult result, Operation<Void> original) {
        original.call(new Object[]{result});
        if (this.confluence$isDisappearingOnGround()) {
            this.discard();
        }
    }
}

