/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.fluids.FluidType;
import org.confluence.mod.api.event.ShimmerEntityTransmutationEvent;
import org.confluence.mod.common.block.common.AetheriumCauldronBlock;
import org.confluence.mod.common.data.saved.GamePhase;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.mod.common.init.ModFluids;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.integration.terra_entity.IAbstractTerraNPC;
import org.confluence.mod.mixed.IEntity;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;
import org.confluence.terraentity.entity.npc.AnglerNPC;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IEntity {
    @Unique
    private boolean confluence$isInShimmer = false;
    @Unique
    private boolean confluence$wasInShimmer = false;
    @Unique
    private int confluence$entity_coolDown = 0;
    @Unique
    private int confluence$entity_transforming = 0;
    @Unique
    private byte confluence$transformData = (byte)-1;

    @Shadow
    public abstract DamageSources damageSources();

    @Shadow(remap=false)
    public abstract FluidType getEyeInFluidType();

    @Shadow
    public abstract void discard();

    @Shadow
    public abstract void setNoGravity(boolean var1);

    @Shadow
    public abstract void setGlowingTag(boolean var1);

    @Shadow
    public abstract Vec3 getDeltaMovement();

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract EntityType<?> getType();

    @Shadow
    public abstract boolean is(Entity var1);

    @Shadow
    public abstract BlockState getInBlockState();

    @Shadow
    public abstract BlockPos blockPosition();

    @Override
    public void confluence$entity_setCoolDown(int ticks) {
        this.confluence$entity_coolDown = ticks;
    }

    @Override
    public void confluence$setOriginalNoGravity(boolean bool) {
        this.confluence$transformData = bool ? (byte)1 : 0;
    }

    @Override
    public boolean confluence$isInShimmer() {
        return this.confluence$isInShimmer;
    }

    @Inject(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V")})
    private void shimmerTick(CallbackInfo ci) {
        Entity self = (Entity)this.confluence$self();
        if (self instanceof PartEntity) {
            return;
        }
        if (this.confluence$entity_coolDown < 0) {
            this.confluence$entity_coolDown = 0;
        }
        if (this.confluence$checkInShimmer()) {
            if (!this.confluence$isInShimmer) {
                this.confluence$isInShimmer = true;
                self.level().playSound(null, self.getX(), self.getY(), self.getZ(), self instanceof ItemEntity ? (SoundEvent)ModSoundEvents.SHIMMER_ITEM_INTERACTIONS.get() : (SoundEvent)ModSoundEvents.SHIMMER_IMMERSION.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
            }
        } else if (this.confluence$isInShimmer) {
            this.confluence$isInShimmer = false;
            self.level().playSound(null, self.getX(), self.getY(), self.getZ(), (SoundEvent)ModSoundEvents.SHIMMER_DETACHMENT.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
        }
        if (this.confluence$isInShimmer) {
            if (this.confluence$entity_coolDown == 0 && !self.level().isClientSide && !(self instanceof ItemEntity)) {
                ShimmerEntityTransmutationEvent.Pre pre = new ShimmerEntityTransmutationEvent.Pre(self);
                if (((ShimmerEntityTransmutationEvent.Pre)NeoForge.EVENT_BUS.post((Event)pre)).isCanceled()) {
                    EntityMixin.confluence$setup(self, pre.getCoolDown(), pre.getSpeedY());
                } else if (this.confluence$entity_transforming < pre.getTransformTime()) {
                    ++this.confluence$entity_transforming;
                    self.addDeltaMovement(ANTI_GRAVITY);
                } else {
                    ShimmerEntityTransmutationEvent.Post post = new ShimmerEntityTransmutationEvent.Post(self);
                    EntityMixin.confluence$initTarget(post);
                    NeoForge.EVENT_BUS.post((Event)post);
                    Entity target = post.getTarget();
                    if (target != null) {
                        this.discard();
                        EntityMixin.confluence$setup(target, post.getCoolDown(), post.getSpeedY());
                        self.level().addFreshEntity(target);
                        self.level().playSound(null, self.getX(), self.getY(), self.getZ(), (SoundEvent)ModSoundEvents.SHIMMER_EVOLUTION.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
                        return;
                    }
                }
            }
            if (!this.confluence$wasInShimmer && self instanceof Projectile) {
                Projectile projectile = (Projectile)self;
                Vec3 motion = projectile.getDeltaMovement();
                projectile.setDeltaMovement(motion.x, -motion.y, motion.z);
                this.confluence$wasInShimmer = true;
            }
        } else {
            this.confluence$entity_transforming = 0;
            if (--this.confluence$entity_coolDown == 0 && this.confluence$transformData != -1 && !(self instanceof ItemEntity)) {
                this.setGlowingTag(false);
                if (this.confluence$transformData == 0) {
                    this.setNoGravity(false);
                }
                this.confluence$transformData = (byte)-1;
            }
            this.confluence$wasInShimmer = false;
        }
    }

    @Unique
    private static void confluence$setup(Entity entity, int coolDown, double y) {
        IEntity iEntity = IEntity.of(entity);
        iEntity.confluence$setOriginalNoGravity(entity.isNoGravity());
        iEntity.confluence$entity_setCoolDown(coolDown);
        entity.setNoGravity(true);
        Vec3 motion = entity.getDeltaMovement();
        entity.setDeltaMovement(motion.x, y, motion.z);
        entity.setGlowingTag(true);
    }

    @Unique
    private static void confluence$initTarget(ShimmerEntityTransmutationEvent.Post event) {
        Entity sourceEntity = event.getSource();
        GamePhase gamePhase = KillBoard.INSTANCE.getGamePhase();
        for (ShimmerEntityTransmutationEvent.EntityTransmutation transmutation : ShimmerEntityTransmutationEvent.ENTITY_TRANSMUTATION) {
            Entity target;
            if (transmutation.gamePhase().isAboveThan(gamePhase) || !transmutation.source().test(sourceEntity) || (target = transmutation.target().create(sourceEntity.level())) == null) continue;
            target.setPos(sourceEntity.position());
            target.setXRot(sourceEntity.getXRot());
            target.setYRot(sourceEntity.getYRot());
            target.setYHeadRot(sourceEntity.getYHeadRot());
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                if (sourceEntity instanceof LivingEntity) {
                    LivingEntity livingSource = (LivingEntity)sourceEntity;
                    float ratio = livingSource.getHealth() / livingSource.getMaxHealth();
                    livingTarget.setHealth(livingTarget.getMaxHealth() * ratio);
                }
            }
            event.setTarget(target);
            if (sourceEntity instanceof AbstractTerraNPC) {
                AbstractTerraNPC sourceNpc = (AbstractTerraNPC)sourceEntity;
                if (target instanceof AbstractTerraNPC) {
                    AbstractTerraNPC targetNpc = (AbstractTerraNPC)target;
                    targetNpc.setHouse(sourceNpc.getHouse());
                    event.setSpeedY(0.7);
                    NPCSpawner.INSTANCE.setNPCAlive(((IAbstractTerraNPC)sourceNpc).confluence$getRegion(), sourceNpc.getType(), false);
                    if (target instanceof AnglerNPC) {
                        AnglerNPC anglerNPC = (AnglerNPC)target;
                        anglerNPC.setWakeUp(true);
                        anglerNPC.initName();
                        anglerNPC.refreshBrain((ServerLevel)sourceEntity.level());
                        anglerNPC.refreshDimensions();
                    }
                }
            }
            return;
        }
    }

    @Unique
    private boolean confluence$checkInShimmer() {
        if (this.getEyeInFluidType() == ModFluids.SHIMMER.type().get()) {
            return true;
        }
        BlockState state = this.getInBlockState();
        Block block = state.getBlock();
        return block == ModBlocks.AETHERIUM_CAULDRON.get() && ((AetheriumCauldronBlock)block).isEntityInsideContent(state, this.blockPosition(), (Entity)this.confluence$self());
    }
}

