/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.confluence.mod.api.event.ShimmerItemTransmutationEvent;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.data.saved.GamePhase;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.init.ModAdvancements;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.recipe.ItemTransmutationRecipe;
import org.confluence.mod.mixed.IEntity;
import org.confluence.mod.mixed.IItemEntity;
import org.confluence.mod.util.PrefixUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
implements IItemEntity {
    @Unique
    private static final Vec3 ANTI_GRAVITY = new Vec3(0.0, (double)-5.0E-4f, 0.0);
    @Unique
    private int confluence$item_coolDown = 0;
    @Unique
    private int confluence$item_transforming = 0;

    @Shadow
    public abstract ItemStack getItem();

    @Override
    public void confluence$item_setCoolDown(int ticks) {
        this.confluence$item_coolDown = ticks;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void endTick(CallbackInfo ci) {
        ItemEntity self = (ItemEntity)this;
        Level level = self.level();
        if (level.isClientSide || self.isRemoved()) {
            return;
        }
        if (this.confluence$item_coolDown < 0) {
            this.confluence$item_coolDown = 0;
        }
        if (this.confluence$item_coolDown == 0 && IEntity.of((Entity)self).confluence$isInShimmer()) {
            ShimmerItemTransmutationEvent.Pre pre = new ShimmerItemTransmutationEvent.Pre(self);
            if (((ShimmerItemTransmutationEvent.Pre)NeoForge.EVENT_BUS.post((Event)pre)).isCanceled()) {
                self.getItem().shrink(pre.getShrink());
                ItemEntityMixin.confluence$setup(self, pre.getCoolDown(), pre.getSpeedY());
            } else if (this.confluence$item_transforming < pre.getTransformTime()) {
                ++this.confluence$item_transforming;
                self.addDeltaMovement(ANTI_GRAVITY);
            } else {
                ShimmerItemTransmutationEvent.Post post = new ShimmerItemTransmutationEvent.Post(self);
                ItemEntityMixin.confluence$initTargets(post);
                NeoForge.EVENT_BUS.post((Event)post);
                List<ItemStack> targets = post.getTargets();
                self.getItem().shrink(post.getShrink());
                if (targets == null) {
                    ItemEntityMixin.confluence$setup(self, post.getCoolDown(), post.getSpeedY());
                } else {
                    ServerPlayer player;
                    Entity entity = self.getOwner();
                    ServerPlayer serverPlayer = entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null;
                    for (ItemStack target : targets) {
                        if (PrefixUtils.canInit(target)) {
                            PrefixUtils.unknown(target);
                        }
                        ItemEntity itemEntity = new ItemEntity(level, self.getX(), self.getY(), self.getZ(), target);
                        ItemEntityMixin.confluence$setup(itemEntity, post.getCoolDown(), post.getSpeedY());
                        if (serverPlayer != null) {
                            target.onCraftedBy(level, (Player)serverPlayer, target.getCount());
                        }
                        level.addFreshEntity((Entity)itemEntity);
                    }
                    level.playSound(null, self.getX(), self.getY(), self.getZ(), (SoundEvent)ModSoundEvents.SHIMMER_EVOLUTION.get(), SoundSource.AMBIENT, 0.5f, 1.0f);
                    if (serverPlayer != null) {
                        ModAdvancements.CriterionTriggerz.SHIMMER_TRANSMUTATION.get().trigger(serverPlayer, (Entity)self);
                    }
                }
            }
        } else if (this.confluence$item_coolDown > 0) {
            --this.confluence$item_coolDown;
        }
    }

    @Unique
    private static void confluence$setup(ItemEntity entity, int coolDown, double y) {
        entity.setNoGravity(true);
        Vec3 motion = entity.getDeltaMovement();
        entity.setDeltaMovement(motion.x, y, motion.z);
        IItemEntity.of(entity).confluence$item_setCoolDown(coolDown);
        entity.setGlowingTag(true);
    }

    @Unique
    private static void confluence$initTargets(ShimmerItemTransmutationEvent.Post event) {
        ItemEntity source = event.getSource();
        ItemStack sourceItem = source.getItem();
        GamePhase gamePhase = KillBoard.INSTANCE.getGamePhase();
        List recipes = source.level().getRecipeManager().getRecipesFor(ModRecipes.ITEM_TRANSMUTATION_TYPE.get(), (RecipeInput)new SingleRecipeInput(sourceItem), source.level());
        Iterator iterator = recipes.iterator();
        if (iterator.hasNext()) {
            RecipeHolder recipeHolder = (RecipeHolder)iterator.next();
            ItemTransmutationRecipe recipe = (ItemTransmutationRecipe)recipeHolder.value();
            if (!recipe.isValid()) {
                return;
            }
            int times = sourceItem.getCount() / recipe.shrink();
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            for (ItemStack result : recipe.target()) {
                int count;
                int maxStackSize = result.getMaxStackSize();
                for (count = result.getCount() * times; count > maxStackSize; count -= maxStackSize) {
                    results.add(result.copyWithCount(maxStackSize));
                }
                results.add(result.copyWithCount(count));
            }
            event.setShrink(recipe.shrink() * times);
            event.setTargets(results);
            return;
        }
        if (!((Boolean)CommonConfigs.SHIMMER_DECOMPOSE.get()).booleanValue()) {
            return;
        }
        if (sourceItem.getDamageValue() != 0) {
            return;
        }
        RegistryAccess registryAccess = source.level().registryAccess();
        boolean isHardmode = gamePhase.isHardmode();
        RandomSource random = source.level().random;
        for (RecipeHolder recipeHolder : ((ServerLevel)source.level()).getServer().getRecipeManager().getRecipes()) {
            Recipe recipe = recipeHolder.value();
            if (recipe.isSpecial() || recipe.isIncomplete() || recipe instanceof AbstractCookingRecipe) continue;
            ItemStack resultItem = recipe.getResultItem((HolderLookup.Provider)registryAccess);
            if (sourceItem.getCount() < resultItem.getCount() || !ItemStack.isSameItem((ItemStack)sourceItem, (ItemStack)resultItem)) continue;
            int times = sourceItem.getCount() / resultItem.getCount();
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            for (Ingredient ingredient : recipe.getIngredients()) {
                int count;
                ItemStack result;
                Object[] itemStacks = ingredient.getItems();
                if (itemStacks.length == 0 || Arrays.stream(itemStacks).allMatch(itemStack -> itemStack.is(ModTags.Items.HARDMODE))) continue;
                Object input = (ItemStack)Util.getRandom((Object[])itemStacks, (RandomSource)random);
                if (!isHardmode && input.is(ModTags.Items.HARDMODE)) {
                    for (int i = 0; i < itemStacks.length && input.is(ModTags.Items.HARDMODE); ++i) {
                        input = itemStacks[i];
                    }
                    if (input.is(ModTags.Items.HARDMODE)) continue;
                }
                if ((result = input.copy()).getItem().hasCraftingRemainingItem(result)) continue;
                int maxStackSize = result.getMaxStackSize();
                for (count = result.getCount() * times; count > maxStackSize; count -= maxStackSize) {
                    ItemStack copy = result.copy();
                    copy.setCount(maxStackSize);
                    results.add(copy);
                }
                result.setCount(count);
                results.add(result);
            }
            if (results.isEmpty()) continue;
            event.setShrink(resultItem.getCount() * times);
            event.setTargets(results);
            return;
        }
    }
}

