/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.integration.sodium;

import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.mod.client.effect.textures.GraySpriteShifterEntry;
import org.confluence.mod.client.effect.textures.LocalBrushData;
import org.confluence.mod.integration.sodium.IMutableQuadViewImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderer"}, remap=false)
public abstract class BlockRendererMixin {
    @Unique
    private BlockPos confluence$pos;

    @Inject(method={"renderModel"}, at={@At(value="HEAD")})
    private void cachePos(BakedModel model, BlockState state, BlockPos pos, BlockPos origin, CallbackInfo ci) {
        this.confluence$pos = pos;
    }

    @Inject(method={"processQuad"}, at={@At(value="HEAD")})
    private void cacheColor(MutableQuadViewImpl quad, CallbackInfo ci, @Share(value="colorData") LocalIntRef colorData) {
        colorData.set(LocalBrushData.getColor(this.confluence$pos, ((ModelQuadView)quad).getLightFace()));
    }

    @ModifyVariable(method={"processQuad"}, at=@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/pipeline/BlockRenderer;colorizeQuad(Lnet/caffeinemc/mods/sodium/client/render/frapi/mesh/MutableQuadViewImpl;I)V"))
    private boolean illuminant(boolean emissive, @Share(value="colorData") LocalIntRef colorData) {
        return emissive || colorData.get() == -4;
    }

    @Inject(method={"processQuad"}, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/pipeline/BlockRenderer;bufferQuad(Lnet/caffeinemc/mods/sodium/client/render/frapi/mesh/MutableQuadViewImpl;[FLnet/caffeinemc/mods/sodium/client/render/chunk/terrain/material/Material;)V")})
    private void setColor(MutableQuadViewImpl quad, CallbackInfo ci, @Share(value="colorData") LocalIntRef colorData) {
        int color = colorData.get();
        if (color == -1 || color == -4 || color == -5) {
            return;
        }
        IMutableQuadViewImpl view = (IMutableQuadViewImpl)quad;
        if (color == -3) {
            ModelQuadView view1 = (ModelQuadView)quad;
            for (int i = 0; i < 4; ++i) {
                int color1 = view1.getColor(i);
                if ((color1 & 0xFFFFFF) == 0xFFFFFF) continue;
                int comp0 = 255 - (color1 & 0xFF);
                int comp1 = 255 - (color1 >>> 8 & 0xFF);
                int comp2 = 255 - (color1 >>> 16 & 0xFF);
                int comp3 = color1 >>> 24 & 0xFF;
                view.confluence$color(i, comp0 | comp1 << 8 | comp2 << 16 | comp3 << 24);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                view.confluence$color(i, color | 0xFF000000);
            }
        }
    }

    @ModifyReceiver(method={"bufferQuad"}, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/buffers/ChunkModelBuilder;addSprite(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)V")})
    private ChunkModelBuilder addGray(ChunkModelBuilder instance, TextureAtlasSprite textureAtlasSprite, @Local(argsOnly=true) MutableQuadViewImpl quad) {
        GraySpriteShifterEntry entry = ((IMutableQuadViewImpl)quad).confluence$getEntry();
        if (entry != null) {
            instance.addSprite(entry.gray());
            instance.addSprite(entry.negative());
        }
        return instance;
    }
}

