/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.integration.terrablender;

import com.bawnorton.mixinsquared.TargetHandler;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.mod.common.init.ModBiomes;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.worldgen.BannedBiomeMultiNoiseBiomeSource;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.mod.mixed.IMultiNoiseBiomeSource;
import org.confluence.mod.mixed.IWorldOptions;
import org.confluence.mod.util.OverworldUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiNoiseBiomeSource.class}, priority=1100)
public abstract class MixinMultiNoiseBiomeSourceSquared
implements IMultiNoiseBiomeSource {
    @Unique
    private List<Holder<Biome>> confluence$jungle;
    @Unique
    private Pair<Holder<Biome>, Holder<Biome>> confluence$biomePair;
    @Unique
    private Holder<Biome> confluence$protection;

    @TargetHandler(mixin="terrablender.mixin.MixinMultiNoiseBiomeSource", name="getNoiseBiome")
    @Inject(method={"@MixinSquared:Handler"}, at={@At(value="TAIL")})
    private void replaceBiome(int x, int y, int z, Climate.Sampler sampler, CallbackInfoReturnable<Holder<Biome>> cir, CallbackInfo ci) {
        OverworldUtils.replaceBiome((MultiNoiseBiomeSource)this.confluence$self(), x, y, z, cir, () -> {
            if (this.confluence$jungle == null) {
                this.confluence$jungle = new ArrayList<Holder<Biome>>();
                Set set = ((MultiNoiseBiomeSource)this.confluence$self()).possibleBiomes().stream().filter(holder -> holder.is(Tags.Biomes.IS_JUNGLE)).collect(Collectors.toSet());
                this.confluence$jungle.addAll(set);
            }
            return this.confluence$jungle;
        }, this::confluence$getBiomePair, registryAccess -> {
            if (this.confluence$protection == null) {
                this.confluence$protection = registryAccess.holderOrThrow(Biomes.PLAINS);
            }
            return this.confluence$protection;
        });
    }

    @Override
    public Pair<Holder<Biome>, Holder<Biome>> confluence$getBiomePair() {
        if (this.confluence$biomePair == null) {
            ResourceKey<Biome> to;
            ResourceKey<Biome> from;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return null;
            }
            WorldOptions worldOptions = server.getWorldData().worldGenOptions();
            long flag = IWorldOptions.of(worldOptions).confluence$getSecretFlag();
            if (this.confluence$self() instanceof BannedBiomeMultiNoiseBiomeSource) {
                this.confluence$biomePair = new Pair(null, null);
                return this.confluence$biomePair;
            }
            if (ModSecretSeeds.DRUNK_WORLD.match(flag)) {
                IMinecraftServer.of(server).confluence$updateSecretFlag(3L);
                this.confluence$biomePair = new Pair(null, null);
                return this.confluence$biomePair;
            }
            if ((flag & 3L) == 0L) {
                if (new LegacyRandomSource(worldOptions.seed()).nextBoolean()) {
                    from = ModBiomes.THE_CORRUPTION;
                    to = ModBiomes.THE_CRIMSON;
                    IMinecraftServer.of(server).confluence$updateSecretFlag(2L);
                } else {
                    from = ModBiomes.THE_CRIMSON;
                    to = ModBiomes.THE_CORRUPTION;
                    IMinecraftServer.of(server).confluence$updateSecretFlag(1L);
                }
            } else if ((flag & 1L) == 0L) {
                from = ModBiomes.THE_CORRUPTION;
                to = ModBiomes.THE_CRIMSON;
            } else {
                from = ModBiomes.THE_CRIMSON;
                to = ModBiomes.THE_CORRUPTION;
            }
            Registry biomes = server.registryAccess().registryOrThrow(Registries.BIOME);
            this.confluence$biomePair = new Pair((Object)biomes.getHolderOrThrow(from), (Object)biomes.getHolderOrThrow(to));
        }
        return this.confluence$biomePair;
    }
}

