/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.item;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.common.CoinItem;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.mod.util.PrefixUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class})
public abstract class InventoryMixin {
    @Shadow
    @Final
    public Player player;

    @Shadow
    protected abstract boolean hasRemainingSpaceForItem(ItemStack var1, ItemStack var2);

    @Inject(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void add2Extra(int slot, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        block8: {
            block9: {
                block11: {
                    block10: {
                        block7: {
                            if (!stack.is(ModTags.Items.COINS)) break block7;
                            ExtraInventory extraInventory = ExtraInventory.of((LivingEntity)this.player);
                            if (this.confluence$insert2Extra(4, extraInventory, stack, extraInventory1 -> {
                                for (int i = 0; i < 4; ++i) {
                                    ItemStack coins = extraInventory.getCoins(i);
                                    int count = coins.getCount();
                                    if (count < 100) continue;
                                    Item coin = coins.getItem();
                                    ItemStack itemStack = null;
                                    if (coin == ModItems.COPPER_COIN.get()) {
                                        itemStack = ((CoinItem)((Object)((Object)ModItems.SILVER_COIN.get()))).getDefaultInstance();
                                    } else if (coin == ModItems.SILVER_COIN.get()) {
                                        itemStack = ((CoinItem)((Object)((Object)ModItems.GOLD_COIN.get()))).getDefaultInstance();
                                    } else if (coin == ModItems.GOLD_COIN.get()) {
                                        itemStack = ((CoinItem)((Object)((Object)ModItems.PLATINUM_COIN.get()))).getDefaultInstance();
                                    }
                                    if (itemStack == null) continue;
                                    coins.setCount(count % 100);
                                    extraInventory1.setCoins(i, coins);
                                    itemStack.setCount(count / 100);
                                    this.confluence$insert2Extra(4, (ExtraInventory)extraInventory1, itemStack, extraInventory2 -> {}, extraInventory1::getCoins, extraInventory1::setCoins);
                                }
                            }, extraInventory::getCoins, extraInventory::setCoins)) {
                                PlayerUtils.sortCoins(this.player);
                                cir.setReturnValue((Object)true);
                            }
                            break block8;
                        }
                        if (!stack.is(ModTags.Items.AMMO)) break block9;
                        if (CommonConfigs.ammoSlotsItemBlackList.stream().anyMatch(arg_0 -> ((Holder.Reference)stack.getItem().builtInRegistryHolder()).is(arg_0))) break block10;
                        if (!CommonConfigs.ammoSlotsTagBlackList.stream().anyMatch(arg_0 -> ((ItemStack)stack).is(arg_0))) break block11;
                    }
                    return;
                }
                ExtraInventory extraInventory = ExtraInventory.of((LivingEntity)this.player);
                if (this.confluence$insert2Extra(4, extraInventory, stack, extraInventory2 -> {}, extraInventory::getAmmo, extraInventory::setAmmo)) {
                    cir.setReturnValue((Object)true);
                }
                break block8;
            }
            if (!stack.isEmpty() && PrefixUtils.canInit(stack)) {
                PrefixUtils.initPrefix(this.player.getRandom(), stack);
            }
        }
    }

    @Inject(method={"setItem"}, at={@At(value="HEAD")})
    private void initPrefix(int index, ItemStack stack, CallbackInfo ci) {
        if (!stack.isEmpty() && PrefixUtils.canInit(stack)) {
            PrefixUtils.initPrefix(this.player.getRandom(), stack);
        }
    }

    @Inject(method={"clearOrCountMatchingItems"}, at={@At(value="RETURN")}, cancellable=true)
    private void withExtra(Predicate<ItemStack> stackPredicate, int maxCount, Container inventory, CallbackInfoReturnable<Integer> cir, @Local boolean flag) {
        cir.setReturnValue((Object)ContainerHelper.clearOrCountMatchingItems((Container)ExtraInventory.of((LivingEntity)this.player), stackPredicate, (int)(maxCount - (Integer)cir.getReturnValue()), (boolean)flag));
    }

    @Unique
    private boolean confluence$insert2Extra(int size, ExtraInventory extraInventory, ItemStack stack, Consumer<ExtraInventory> consumer, IntFunction<ItemStack> getter, BiConsumer<Integer, ItemStack> setter) {
        int i;
        do {
            i = stack.getCount();
            stack.setCount(this.confluence$addResource2Extra(size, stack, getter, setter));
            consumer.accept(extraInventory);
        } while (!stack.isEmpty() && stack.getCount() < i);
        if (stack.getCount() == i && this.player.hasInfiniteMaterials()) {
            stack.setCount(0);
            return true;
        }
        return stack.getCount() < i;
    }

    @Unique
    private int confluence$addResource2Extra(int size, ItemStack stack, IntFunction<ItemStack> getter, BiConsumer<Integer, ItemStack> setter) {
        int j;
        int k;
        int index;
        boolean found = false;
        for (index = 0; index < size; ++index) {
            ItemStack itemStack = getter.apply(index);
            if (!itemStack.isEmpty() && !this.hasRemainingSpaceForItem(itemStack, stack)) continue;
            found = true;
            break;
        }
        if (!found) {
            return stack.getCount();
        }
        int i = stack.getCount();
        ItemStack itemStack = getter.apply(index);
        if (itemStack.isEmpty()) {
            itemStack = stack.copyWithCount(0);
            setter.accept(index, itemStack);
        }
        if ((k = Math.min(i, j = stack.getMaxStackSize() - itemStack.getCount())) != 0) {
            i -= k;
            itemStack.grow(k);
            itemStack.setPopTime(5);
        }
        return i;
    }
}

