/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.level;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Stream;
import net.minecraft.world.level.levelgen.WorldOptions;
import org.confluence.mod.mixed.IWorldOptions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WorldOptions.class})
public abstract class WorldOptionsMixin
implements IWorldOptions {
    @Shadow
    @Final
    private long seed;
    @Shadow
    @Final
    private boolean generateStructures;
    @Shadow
    @Final
    private boolean generateBonusChest;
    @Shadow
    @Final
    private Optional<String> legacyCustomOptions;
    @Unique
    private long confluence$secretFlag = 0L;

    @Override
    public void confluence$withSecretFlag(long flag) {
        this.confluence$secretFlag |= flag;
    }

    @Override
    public long confluence$getSecretFlag() {
        return this.confluence$secretFlag;
    }

    @Override
    public WorldOptions confluence$copyWithoutSecretFlag() {
        return new WorldOptions(this.seed, this.generateStructures, this.generateBonusChest, this.legacyCustomOptions);
    }

    @ModifyExpressionValue(method={"<clinit>"}, at={@At(value="INVOKE", target="Lcom/mojang/serialization/codecs/RecordCodecBuilder;mapCodec(Ljava/util/function/Function;)Lcom/mojang/serialization/MapCodec;")})
    private static MapCodec<WorldOptions> wrapCodec(final MapCodec<WorldOptions> original) {
        return new MapCodec<WorldOptions>(){
            private final String secretFlagName = "secret_flag";

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.concat(Stream.of(ops.createString("secret_flag")), original.keys(ops));
            }

            public <T> DataResult<WorldOptions> decode(DynamicOps<T> ops, MapLike<T> input) {
                DataResult result = original.decode(ops, input);
                result.result().ifPresent(value -> {
                    long secretFlag = ops.getNumberValue(input.get("secret_flag"), (Number)0L).longValue();
                    IWorldOptions.of(value).confluence$withSecretFlag(secretFlag);
                });
                return result;
            }

            public <T> RecordBuilder<T> encode(WorldOptions input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                return original.encode((Object)input, ops, prefix).add("secret_flag", ops.createLong(IWorldOptions.of(input).confluence$getSecretFlag()));
            }

            public String toString() {
                return super.toString() + "(SecretFlag)";
            }
        };
    }

    @Inject(method={"withSeed"}, at={@At(value="RETURN")})
    private void withSecretFlag1(OptionalLong seed, CallbackInfoReturnable<WorldOptions> cir) {
        IWorldOptions.of((WorldOptions)cir.getReturnValue()).confluence$withSecretFlag(this.confluence$secretFlag);
    }

    @Inject(method={"withStructures"}, at={@At(value="RETURN")})
    private void withSecretFlag2(boolean generateStructures, CallbackInfoReturnable<WorldOptions> cir) {
        IWorldOptions.of((WorldOptions)cir.getReturnValue()).confluence$withSecretFlag(this.confluence$secretFlag);
    }

    @Inject(method={"withBonusChest"}, at={@At(value="RETURN")})
    private void withSecretFlag3(boolean generateBonusChest, CallbackInfoReturnable<WorldOptions> cir) {
        IWorldOptions.of((WorldOptions)cir.getReturnValue()).confluence$withSecretFlag(this.confluence$secretFlag);
    }
}

