/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.network.IPacketC2S;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.entity.hook.AbstractHookEntity;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.item.hook.BaseHookItem;

public record HookThrowingPacketC2S(boolean throwing, int id) implements IPacketC2S
{
    public static final CustomPacketPayload.Type<HookThrowingPacketC2S> TYPE = Confluence.createType("hook_throwing");
    public static final StreamCodec<FriendlyByteBuf, HookThrowingPacketC2S> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, HookThrowingPacketC2S>(){

        public HookThrowingPacketC2S decode(FriendlyByteBuf buffer) {
            boolean throwing = buffer.readBoolean();
            int id = 0;
            if (!throwing) {
                id = buffer.readVarInt();
            }
            return new HookThrowingPacketC2S(throwing, id);
        }

        public void encode(FriendlyByteBuf buffer, HookThrowingPacketC2S value) {
            buffer.writeBoolean(value.throwing);
            if (!value.throwing) {
                buffer.writeVarInt(value.id);
            }
        }
    };

    public CustomPacketPayload.Type<HookThrowingPacketC2S> type() {
        return TYPE;
    }

    public void work(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        if (this.throwing) {
            ExtraInventory extraInventory = ExtraInventory.of((LivingEntity)player);
            ItemStack itemStack = extraInventory.getHook(false);
            Item item = itemStack.getItem();
            if (!(item instanceof BaseHookItem)) {
                return;
            }
            BaseHookItem item2 = (BaseHookItem)item;
            if (item2.canHook(level, extraInventory, itemStack)) {
                AbstractHookEntity hookEntity;
                ListTag listTag = LibUtils.getItemStackNbt((ItemStack)itemStack).getList("hooks", 10);
                BaseHookItem.HookType hookType = item2.getHookType();
                if (hookType == BaseHookItem.HookType.SINGLE) {
                    LibUtils.updateItemStackNbt((ItemStack)itemStack, nbt -> {
                        BaseHookItem.discardAllHooks(listTag, level);
                        nbt.put("hooks", (Tag)listTag);
                        extraInventory.setChanged();
                    });
                } else if (hookType == BaseHookItem.HookType.SIMULTANEOUS && listTag.size() == item2.getHookAmount() && (hookEntity = BaseHookItem.getHookEntity((Tag)listTag.getFirst(), (Level)level)) != null) {
                    hookEntity.setHookState(AbstractHookEntity.HookState.POP);
                    LibUtils.updateItemStackNbt((ItemStack)itemStack, nbt -> {
                        listTag.removeFirst();
                        nbt.put("hooks", (Tag)listTag);
                        extraInventory.setChanged();
                    });
                }
                AbstractHookEntity hook = item2.getHook(itemStack, item2, (Player)player, (Level)level);
                hook.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, item2.getHookVelocity(), 0.5f);
                level.addFreshEntity((Entity)hook);
                LibUtils.updateItemStackNbt((ItemStack)itemStack, nbt -> {
                    CompoundTag tag = new CompoundTag();
                    tag.putInt("id", hook.getId());
                    listTag.add((Object)tag);
                    nbt.put("hooks", (Tag)listTag);
                    extraInventory.setChanged();
                });
                HitResult hitResult = player.pick((double)item2.getHookRange(), 1.0f, false);
                float ratio = hitResult.getType() == HitResult.Type.MISS ? 0.5f : Mth.clamp((float)((float)(hitResult.distanceTo((Entity)player) / (double)item2.getHookRange())), (float)0.0f, (float)1.0f);
                level.playSound(null, player.getX() + hook.getDeltaMovement().x, player.getEyeY() + hook.getDeltaMovement().y, player.getZ() + hook.getDeltaMovement().z, (SoundEvent)ModSoundEvents.HOOK_SHOOT.get(), SoundSource.PLAYERS, 0.3f * ratio, 1.0f);
            }
        } else {
            Entity entity = level.getEntity(this.id);
            if (entity instanceof AbstractHookEntity) {
                AbstractHookEntity hookEntity = (AbstractHookEntity)entity;
                hookEntity.setHookState(AbstractHookEntity.HookState.POP);
            }
        }
    }

    public static void push() {
        PacketDistributor.sendToServer((CustomPacketPayload)new HookThrowingPacketC2S(true, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void pop(int id) {
        PacketDistributor.sendToServer((CustomPacketPayload)new HookThrowingPacketC2S(false, id), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

