/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.network.IPacketC2S;
import org.confluence.mod.Confluence;
import org.confluence.mod.mixed.IMobEffectInstance;
import org.confluence.mod.util.ModUtils;

public record SwitchEffectEnabledPackedC2S(Holder<MobEffect> effect, boolean enabled) implements IPacketC2S
{
    public static final CustomPacketPayload.Type<SwitchEffectEnabledPackedC2S> TYPE = Confluence.createType("switch_effect_enabled");
    public static final StreamCodec<RegistryFriendlyByteBuf, SwitchEffectEnabledPackedC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)MobEffect.STREAM_CODEC, SwitchEffectEnabledPackedC2S::effect, (StreamCodec)ByteBufCodecs.BOOL, SwitchEffectEnabledPackedC2S::enabled, SwitchEffectEnabledPackedC2S::new);

    public CustomPacketPayload.Type<SwitchEffectEnabledPackedC2S> type() {
        return TYPE;
    }

    public void work(ServerPlayer player) {
        MobEffectInstance instance = (MobEffectInstance)player.getActiveEffectsMap().get(this.effect);
        if (instance != null && ModUtils.isSwitchableEffect(instance)) {
            IMobEffectInstance.of(instance).confluence$setEnabled(this.enabled);
            MobEffect mobEffect = (MobEffect)instance.getEffect().value();
            if (this.enabled) {
                mobEffect.addAttributeModifiers(player.getAttributes(), instance.getAmplifier());
            } else {
                mobEffect.removeAttributeModifiers(player.getAttributes());
            }
            player.effectsDirty = true;
        }
    }

    public static void sendToServer(Holder<MobEffect> effect, boolean enabled) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SwitchEffectEnabledPackedC2S(effect, enabled), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

