/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.confluence.lib.network.IPacketS2C;
import org.confluence.lib.util.LibStreamCodecUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.gui.hud.HouseSelectHUD;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.terraentity.init.entity.TENpcEntities;

public record AvailableHouseSelectPacketS2C(boolean[] available) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<AvailableHouseSelectPacketS2C> TYPE = Confluence.createType("available_house_select");
    public static final int size = 25;
    public static final int traveling_merchant = 20;
    public static final StreamCodec<ByteBuf, AvailableHouseSelectPacketS2C> STREAM_CODEC = LibStreamCodecUtils.booleanArray((int)25).map(AvailableHouseSelectPacketS2C::new, AvailableHouseSelectPacketS2C::available);
    private static EntityType<?>[] TYPES;

    public CustomPacketPayload.Type<AvailableHouseSelectPacketS2C> type() {
        return TYPE;
    }

    public void work(Player player) {
        HouseSelectHUD.handlePacket(this.available);
    }

    public static EntityType<?>[] getTypes() {
        if (TYPES == null) {
            TYPES = new EntityType[]{EntityType.PLAYER, (EntityType)TENpcEntities.GUIDE.get(), (EntityType)TENpcEntities.MERCHANT.get(), (EntityType)TENpcEntities.NURSE.get(), (EntityType)TENpcEntities.DEMOLITIONIST.get(), (EntityType)TENpcEntities.DRYAD.get(), (EntityType)TENpcEntities.ARMS_DEALER.get(), (EntityType)TENpcEntities.CLOTHIER.get(), (EntityType)TENpcEntities.MECHANIC.get(), (EntityType)TENpcEntities.GOBLIN_TINKERER.get(), null, null, (EntityType)TENpcEntities.TRUFFLE.get(), null, (EntityType)TENpcEntities.PARTY_GIRL.get(), null, (EntityType)TENpcEntities.PAINTER.get(), (EntityType)TENpcEntities.WITCH_DOCTOR.get(), null, null, (EntityType)TENpcEntities.TRAVELING_MERCHANT.get(), (EntityType)TENpcEntities.ANGLER.get(), null, null, (EntityType)TENpcEntities.ZOOLOGIST.get()};
        }
        return TYPES;
    }

    public static CustomPacketPayload collectPacket(ServerPlayer player) {
        Object2BooleanMap<EntityType<?>> details = NPCSpawner.INSTANCE.getRegionAliveDetails(new NPCSpawner.Region(player.chunkPosition()));
        boolean[] values = new boolean[25];
        for (int i = 0; i < 25; ++i) {
            EntityType<?> type = AvailableHouseSelectPacketS2C.getTypes()[i];
            if (type == EntityType.PLAYER) {
                values[i] = true;
                continue;
            }
            if (type == null) continue;
            values[i] = details.getBoolean(type);
        }
        return new AvailableHouseSelectPacketS2C(values);
    }
}

