/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.lib.network.IPacketS2C;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.handler.CompatibilityHandler;
import org.confluence.mod.common.CommonConfigs;

public record CompatibilitySyncPacketS2c(int data) implements IPacketS2C
{
    private static ModConfigSpec.BooleanValue[] configs;
    public static final CustomPacketPayload.Type<CompatibilitySyncPacketS2c> TYPE;
    public static final StreamCodec<ByteBuf, CompatibilitySyncPacketS2c> STREAM_CODEC;

    public CustomPacketPayload.Type<CompatibilitySyncPacketS2c> type() {
        return TYPE;
    }

    public void work(Player player) {
        CompatibilityHandler.handle(this.data);
    }

    public static void sendToAll() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)CompatibilitySyncPacketS2c.collectPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToClient(ServerPlayer player) {
        CompatibilitySyncPacketS2c packet = CompatibilitySyncPacketS2c.collectPacket();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static CompatibilitySyncPacketS2c collectPacket() {
        int data = 0;
        ModConfigSpec.BooleanValue[] arr = CompatibilitySyncPacketS2c.getConfigs();
        for (int i = 0; i < arr.length; ++i) {
            if (!((Boolean)arr[i].get()).booleanValue()) continue;
            data |= 1 << i;
        }
        return new CompatibilitySyncPacketS2c(data);
    }

    public static ModConfigSpec.BooleanValue[] getConfigs() {
        if (configs == null) {
            configs = new ModConfigSpec.BooleanValue[]{CommonConfigs.CONVERT_ARS_NOUVEAU_MANA, CommonConfigs.CONVERT_IRONS_SPELL_MANA, CommonConfigs.FTB_CHUNKS_WORMHOLE_POTION, CommonConfigs.WAYSTONES_PYLON_NON_COST};
        }
        return configs;
    }

    static {
        TYPE = Confluence.createType("compatibility_sync");
        STREAM_CODEC = ByteBufCodecs.VAR_INT.map(CompatibilitySyncPacketS2c::new, CompatibilitySyncPacketS2c::data);
    }
}

