/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.lib.network.IPacketS2C;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.attachment.ExtraInventory;

public record ExtraInventoryStackPacketS2C(long packedData, ItemStack itemStack) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<ExtraInventoryStackPacketS2C> TYPE = Confluence.createType("extra_inventory_stack");
    public static final StreamCodec<RegistryFriendlyByteBuf, ExtraInventoryStackPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, ExtraInventoryStackPacketS2C::packedData, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ExtraInventoryStackPacketS2C::itemStack, ExtraInventoryStackPacketS2C::new);

    public CustomPacketPayload.Type<ExtraInventoryStackPacketS2C> type() {
        return TYPE;
    }

    public void work(Player player) {
        Entity entity = player.level().getEntity(this.getEntityId());
        if (entity instanceof Player) {
            Player entity2 = (Player)entity;
            ExtraInventory extraInventory = ExtraInventory.of((LivingEntity)entity2);
            if (extraInventory.getSizeAccessoryDye() != this.getSizeAccessoryDye()) {
                extraInventory.setAccessoryDyes(player, this.getSizeAccessoryDye());
            }
            extraInventory.setItem(this.getSlot(), this.itemStack);
        }
    }

    private int getEntityId() {
        return BlockPos.getX((long)this.packedData);
    }

    private int getSizeAccessoryDye() {
        return BlockPos.getY((long)this.packedData);
    }

    private int getSlot() {
        return BlockPos.getZ((long)this.packedData);
    }

    public static void sendToPlayersTrackingEntityAndSelf(ServerPlayer serverPlayer, ServerPlayer player, int sizeAccessoryDye, int slot, ItemStack itemStack) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            long packedData = BlockPos.asLong((int)player.getId(), (int)sizeAccessoryDye, (int)slot);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverPlayer, (CustomPacketPayload)new ExtraInventoryStackPacketS2C(packedData, itemStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

