/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.network.IPacketS2C;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.attachment.ExtraInventory;

public record ExtraInventorySyncPacketS2C(int entityId, ExtraInventory extraInventory) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<ExtraInventorySyncPacketS2C> TYPE = Confluence.createType("extra_inventory_sync");
    public static final StreamCodec<RegistryFriendlyByteBuf, ExtraInventorySyncPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ExtraInventorySyncPacketS2C::entityId, ExtraInventory.STREAM_CODEC, ExtraInventorySyncPacketS2C::extraInventory, ExtraInventorySyncPacketS2C::new);

    public CustomPacketPayload.Type<ExtraInventorySyncPacketS2C> type() {
        return TYPE;
    }

    public void work(Player player) {
        Entity entity = player.level().getEntity(this.entityId);
        if (entity instanceof Player) {
            Player entity2 = (Player)entity;
            ExtraInventory.of((LivingEntity)entity2).copyFrom(this.extraInventory);
        }
    }

    public static void sendToClient(ServerPlayer sendTo, ServerPlayer target, ExtraInventory extraInventory) {
        extraInventory.initialize(sendTo);
        PacketDistributor.sendToPlayer((ServerPlayer)sendTo, (CustomPacketPayload)new ExtraInventorySyncPacketS2C(target.getId(), extraInventory), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayersTrackingEntityAndSelf(ServerPlayer from, ServerPlayer to, ExtraInventory extraInventory) {
        extraInventory.initialize(from);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)from, (CustomPacketPayload)new ExtraInventorySyncPacketS2C(to.getId(), extraInventory), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

