/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.lib.network.IPacketS2C;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.handler.MeteorLandingHandler;

public record MeteoriteLocationPacketS2C(BlockPos location, int tickUntilLanding) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<MeteoriteLocationPacketS2C> TYPE = Confluence.createType("meteorite_location");
    public static final StreamCodec<ByteBuf, MeteoriteLocationPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, MeteoriteLocationPacketS2C::location, (StreamCodec)ByteBufCodecs.VAR_INT, MeteoriteLocationPacketS2C::tickUntilLanding, MeteoriteLocationPacketS2C::new);

    public CustomPacketPayload.Type<MeteoriteLocationPacketS2C> type() {
        return TYPE;
    }

    public void work(Player player) {
        MeteorLandingHandler.handlePacket(this, player);
    }

    public static void sendToAll(BlockPos location, int tickUntilLanding) {
        if (ServerLifecycleHooks.getCurrentServer() != null && !BlockPos.ZERO.equals((Object)location)) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new MeteoriteLocationPacketS2C(location, tickUntilLanding), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToClient(ServerPlayer player, BlockPos location, int tickUntilLanding) {
        if (BlockPos.ZERO.equals((Object)location)) {
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MeteoriteLocationPacketS2C(location, tickUntilLanding), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

