/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.xiaohunao.mine_team.common.team.Team;
import com.xiaohunao.mine_team.common.team.TeamManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.confluence.lib.util.LibClientUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.block.functional.boulder.AbstractBoulderBlock;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.item.VanityArmorItems;
import org.confluence.mod.common.item.common.BaseDyeItem;
import org.confluence.mod.common.worldgen.secret_seed.TheConstant;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;

public final class ClientUtils {
    public static final String GRAY_SUFFIX = ".gray";
    public static final String NEGATIVE_SUFFIX = ".negative";
    public static final Set<ResourceLocation> ORIGINAL = new HashSet<ResourceLocation>();
    public static final ResourceLocation LEGACY_TEXTURE = Confluence.asResource("hud/icon");
    public static final ResourceLocation OVERLAY_TEXTURE = Confluence.asResource("hud/overlay");
    public static final ResourceLocation ICON_0 = Confluence.asResource("hud/icon_0");
    private static final Set<ResourceLocation> failed = new HashSet<ResourceLocation>();
    public static final int LEGACY_SIZE = 128;
    public static final int OVERLAY_SIZE = 128;
    public static final String DEATH_BONE_NAME = "_death";
    public static final String ENTIRE_BONE_SUFFIX = "_entire";

    public static void clearCache() {
        failed.clear();
        ORIGINAL.clear();
    }

    public static ResourceLocation getGrayTexture(ResourceLocation original) {
        if (failed.contains(original)) {
            return original;
        }
        ResourceLocation gray = original.withSuffix(GRAY_SUFFIX);
        if (Minecraft.getInstance().getTextureManager().getTexture(gray, null) == null) {
            try {
                try (InputStream inputstream = Minecraft.getInstance().getResourceManager().getResourceOrThrow(original).open();){
                    DynamicTexture texture = new DynamicTexture(LibClientUtils.copyWithGray((NativeImage)NativeImage.read((InputStream)inputstream)));
                    Minecraft.getInstance().getTextureManager().register(gray, (AbstractTexture)texture);
                }
                return gray;
            }
            catch (IOException ioexception) {
                failed.add(original);
                return original;
            }
        }
        return gray;
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, @Nullable String text, float x, float y, int color) {
        guiGraphics.drawString(font, text, x + 1.0f, y, 0, false);
        guiGraphics.drawString(font, text, x - 1.0f, y, 0, false);
        guiGraphics.drawString(font, text, x, y + 1.0f, 0, false);
        guiGraphics.drawString(font, text, x, y - 1.0f, 0, false);
        guiGraphics.drawString(font, text, x, y, color, false);
    }

    public static void drawColor(GuiGraphics guiGraphics, int x, int y, int iconX, int iconY, ResourceLocation icon, int color, int colorHigh, int colorLow, int size, int part, int partDis) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float redHigh = (float)(colorHigh >> 16 & 0xFF) / 255.0f;
        float greenHigh = (float)(colorHigh >> 8 & 0xFF) / 255.0f;
        float blueHigh = (float)(colorHigh & 0xFF) / 255.0f;
        float redLow = (float)(colorLow >> 16 & 0xFF) / 255.0f;
        float greenLow = (float)(colorLow >> 8 & 0xFF) / 255.0f;
        float blueLow = (float)(colorLow & 0xFF) / 255.0f;
        if (part >= 1) {
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            guiGraphics.blitSprite(icon, size, size, iconX, iconY, x, y, 9, 9);
        }
        if (part >= 2) {
            RenderSystem.setShaderColor((float)redLow, (float)greenLow, (float)blueLow, (float)1.0f);
            guiGraphics.blitSprite(icon, size, size, iconX + partDis, iconY, x, y, 9, 9);
        }
        if (part >= 3) {
            RenderSystem.setShaderColor((float)redHigh, (float)greenHigh, (float)blueHigh, (float)1.0f);
            guiGraphics.blitSprite(icon, size, size, iconX + partDis * 2, iconY, x, y, 9, 9);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int colorHigh(int color) {
        return color / 255 * 55 + 200;
    }

    public static int colorLow(int color, RandomSource random) {
        int colorT = color - 60 + random.nextInt(121);
        if (colorT < 0) {
            colorT = 0;
        }
        if (colorT > 255) {
            colorT = 255;
        }
        return colorT;
    }

    public static Vector3i color(RandomSource random) {
        int G;
        int R;
        int B;
        do {
            R = random.nextInt(256);
            G = random.nextInt(256);
        } while ((B = random.nextInt(256) + 255 - R - G) > 255 || B < 0);
        int color = R << 16 | G << 8 | B;
        int colorHigh = ClientUtils.colorHigh(R) << 16 | ClientUtils.colorHigh(G) << 8 | ClientUtils.colorHigh(B);
        int colorLow = ClientUtils.colorLow(R, random) << 16 | ClientUtils.colorLow(G, random) << 8 | ClientUtils.colorLow(B, random);
        return new Vector3i(color, colorHigh, colorLow);
    }

    public static void draw(int x, int y, GuiGraphics guiGraphics, int count, int color, int colorHigh, int colorLow, ResourceLocation icon, int size, int uvX, int uvY, boolean left, int part, int partDis) {
        int countT = count / 2;
        int xT = left ? x - 8 : x + 80;
        for (int i = 0; i < countT; ++i) {
            xT = left ? x + i * 8 : x + 72 - i * 8;
            ClientUtils.drawColor(guiGraphics, xT, y, uvX, uvY, icon, color, colorHigh, colorLow, size, part, partDis);
        }
        if (count - countT * 2 == 1) {
            ClientUtils.drawColor(guiGraphics, xT + (left ? 8 : -8), y, uvX + partDis / 2, uvY, icon, color, colorHigh, colorLow, size, part, partDis);
        }
    }

    public static void colorDraw(GuiGraphics guiGraphics, Minecraft minecraft, RandomSource random, ResourceLocation texture, int[] COLOR, int[] COLOR_HIGH, int[] COLOR_LOW, float max, float current, int x, int y, int size, int uvY, boolean left) {
        ClientUtils.colorDraw(guiGraphics, minecraft, random, texture, COLOR, COLOR_HIGH, COLOR_LOW, max, current, x, y, size, uvY, left, true);
    }

    public static void colorDraw(GuiGraphics guiGraphics, Minecraft minecraft, RandomSource random, ResourceLocation texture, int[] COLOR, int[] COLOR_HIGH, int[] COLOR_LOW, float current, int x, int y, int size, int uvY, boolean left) {
        ClientUtils.colorDraw(guiGraphics, minecraft, random, texture, COLOR, COLOR_HIGH, COLOR_LOW, 0.0f, current, x, y, size, uvY, left, false);
    }

    public static void colorDraw(GuiGraphics guiGraphics, Minecraft minecraft, RandomSource random, ResourceLocation texture, int[] COLOR, int[] COLOR_HIGH, int[] COLOR_LOW, float max, float current, int x, int y, int size, int uvY, boolean left, boolean background) {
        int lineCount;
        int backCount = (int)(max / 2.0f);
        int heartCount = (int)current;
        if (max / 2.0f > (float)backCount) {
            ++backCount;
        }
        if (current > (float)heartCount) {
            ++heartCount;
        }
        for (int i = 0; i < backCount && i < 10 && background; ++i) {
            guiGraphics.blitSprite(texture, size, size, 60, uvY, x + i * 8 + (backCount < 10 && !left ? (10 - backCount) * 8 : 0), y, 9, 9);
        }
        int lineCountDraw = lineCount = heartCount / 20;
        Vector3i color = new Vector3i(0, 0, 0);
        for (int i = 0; i <= lineCount; ++i) {
            int drawCount;
            Vector3i colorJ = color;
            int n = drawCount = i == lineCount ? heartCount % 20 : 20;
            if (i < Math.min(COLOR.length, Math.min(COLOR_HIGH.length, COLOR_LOW.length))) {
                color = ClientUtils.color(random);
                color.x = COLOR[i];
                if (lineCount - i < 2) {
                    ClientUtils.draw(x, y, guiGraphics, drawCount, COLOR[i], COLOR_HIGH[i], COLOR_LOW[i], texture, size, 0, uvY, left, 3, 20);
                }
            } else {
                color = ClientUtils.color(random);
                if (lineCount - i < 2) {
                    ClientUtils.draw(x, y, guiGraphics, drawCount, color.x, color.y, color.z, texture, size, 0, uvY, left, 3, 20);
                }
            }
            if (drawCount != 20 && drawCount != 0) {
                lineCountDraw = lineCount + 1;
            }
            if (drawCount != 0) continue;
            color = colorJ;
        }
        String drawString = Integer.toString(lineCountDraw);
        if (lineCountDraw > 1) {
            ClientUtils.drawString(guiGraphics, minecraft.font, drawString, left ? (float)(x - 3 - minecraft.font.width((FormattedText)Component.literal((String)drawString))) : (float)(x + 85), y + 1, color.x);
        }
    }

    public static int getVanityDyeARGB(ExtraInventory extraInventory, int index, Player player) {
        ItemStack vanityArmorDye;
        if (index != -1 && !(vanityArmorDye = extraInventory.getVanityArmor(index, true)).isEmpty()) {
            Team team;
            Item item = vanityArmorDye.getItem();
            if (item instanceof BaseDyeItem) {
                return BaseDyeItem.getARGB(vanityArmorDye);
            }
            if (item == VanityArmorItems.TEAM_DYE.get() && (team = TeamManager.getTeam((Entity)player)) != null) {
                return FastColor.ARGB32.opaque((int)team.getRGB());
            }
        }
        return -1;
    }

    public static <T extends BlockEntity> BlockEntityRendererProvider<T> rendererProvider(Supplier<BlockEntityRenderer<T>> factory) {
        return context -> (BlockEntityRenderer)factory.get();
    }

    public static AABB getRenderBoundingBox3x(BlockPos pos) {
        return new AABB((double)(pos.getX() - 1), (double)(pos.getY() - 1), (double)(pos.getZ() - 1), (double)(pos.getX() + 2), (double)(pos.getY() + 2), (double)(pos.getZ() + 2));
    }

    public static void renderBoulderSun(Minecraft minecraft) {
        if (ModSecretSeeds.BOULDER_WORLD.match()) {
            MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
            BlockState blockState = ((AbstractBoulderBlock)FunctionalBlocks.NORMAL_BOULDER.get()).defaultBlockState();
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(Axis.ZP.rotation(minecraft.level.getTimeOfDay(0.0f) * ((float)Math.PI * 2)));
            poseStack.translate(-5.0f, 100.0f, -5.0f);
            poseStack.scale(10.0f, 10.0f, 10.0f);
            minecraft.getBlockRenderer().renderSingleBlock(blockState, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
    }

    public static void postTheConstantEffect(boolean post) {
        GameRenderer gameRenderer = Minecraft.getInstance().gameRenderer;
        PostChain postChain = gameRenderer.currentEffect();
        if (post) {
            if (postChain == null || !TheConstant.POST_EFFECT.toString().equals(postChain.getName())) {
                gameRenderer.loadEffect(TheConstant.POST_EFFECT);
            }
            gameRenderer.effectActive = true;
        } else if (postChain != null && TheConstant.POST_EFFECT.toString().equals(postChain.getName())) {
            gameRenderer.effectActive = false;
        }
    }
}

