/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import com.ibm.icu.impl.Pair;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ClientHooks;
import org.confluence.lib.client.AntiPushPoseStack;
import org.confluence.lib.client.DummyMultiBufferSource;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.common.entity.DeadBodyPartEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.integration.geckolib.IGeoCube;
import org.confluence.mod.mixed.IEntity;
import org.confluence.mod.mixed.ILivingEntityRenderer;
import org.confluence.mod.mixed.IModelPart;
import org.confluence.mod.mixin.client.accessor.AgeableListModelAccessor;
import org.confluence.mod.util.ModUtils;
import org.confluence.terraentity.client.boss.renderer.WallOfFleshRenderer;
import org.confluence.terraentity.entity.boss.wallofflesh.WallOfFlesh;
import org.confluence.terraentity.entity.util.DeathAnimOptions;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public final class DeathAnimUtils {
    public static final Map<EntityType<? extends LivingEntity>, DeathAnimOptions> options = new HashMap<EntityType<? extends LivingEntity>, DeathAnimOptions>();
    public static final List<Pair<ResourceKey<Level>, Entity>> toBeAdded = new ArrayList<Pair<ResourceKey<Level>, Entity>>();
    public static final List<Entity> toBeDiscarded = new ArrayList<Entity>();

    public static void clear() {
        toBeAdded.clear();
        toBeDiscarded.clear();
    }

    public static void handle(ClientLevel level) {
        for (Pair<ResourceKey<Level>, Entity> pair : toBeAdded) {
            if (pair.first != level.dimension()) continue;
            level.addEntity((Entity)pair.second);
        }
        for (Entity entity : toBeDiscarded) {
            entity.discard();
        }
    }

    public static ModelPart findRootModelPart(LivingEntityRenderer<?, ?> renderer) {
        EntityModel model = renderer.getModel();
        ModelPart any = DeathAnimUtils.findAnyModelPart(model, model.getClass());
        if (any == null) {
            return null;
        }
        return IModelPart.of(any).confluence$root(new ModelPart[0]);
    }

    public static ModelPart findAnyModelPart(Object model, Class<?> finding) {
        if (model instanceof HierarchicalModel) {
            HierarchicalModel hierarchicalModel = (HierarchicalModel)model;
            return hierarchicalModel.root();
        }
        for (Field field : finding.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object object = field.get(model);
                if (!(object instanceof ModelPart)) continue;
                ModelPart part = (ModelPart)object;
                return part;
            }
            catch (IllegalAccessException | InaccessibleObjectException e) {
                Confluence.LOGGER.error("field.get: ", (Throwable)e);
            }
        }
        if (Model.class.isAssignableFrom(finding.getSuperclass())) {
            return DeathAnimUtils.findAnyModelPart(model, finding.getSuperclass());
        }
        return null;
    }

    @Nullable
    public static DeathAnimOptions getDeathAnimOptions(Entity entity) {
        DeathAnimOptions r;
        return entity instanceof DeathAnimOptions ? (r = (DeathAnimOptions)entity) : (entity == null ? null : options.get(entity.getType()));
    }

    public static int calcParticleCount(AABB range) {
        double x = range.getXsize() * range.getYsize() * range.getZsize();
        return (int)(85.0 * Math.log(x + 1.0));
    }

    public static GeoCube duplicateGeoCube(GeoCube geoCube) {
        GeoQuad[] quads = geoCube.quads();
        GeoQuad[] newQuads = new GeoQuad[quads.length];
        float[] avCoords = new float[3];
        float[] minCoords = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE};
        float[] maxCoords = new float[]{-3.4028235E38f, -3.4028235E38f, -3.4028235E38f};
        int coordsCount = 0;
        for (GeoQuad quad : quads) {
            if (quad == null) continue;
            GeoVertex[] vertices = quad.vertices();
            GeoVertex[] newVertex = new GeoVertex[vertices.length];
            for (GeoVertex vertex : vertices) {
                Vector3f pos = vertex.position();
                avCoords[0] = avCoords[0] + pos.x;
                avCoords[2] = avCoords[2] + pos.z;
                if (pos.x < minCoords[0]) {
                    minCoords[0] = pos.x;
                }
                if (pos.x > maxCoords[0]) {
                    maxCoords[0] = pos.x;
                }
                if (pos.y < minCoords[1]) {
                    minCoords[1] = pos.y;
                }
                if (pos.y > maxCoords[1]) {
                    maxCoords[1] = pos.y;
                }
                if (pos.z < minCoords[2]) {
                    minCoords[2] = pos.z;
                }
                if (pos.z > maxCoords[2]) {
                    maxCoords[2] = pos.z;
                }
                ++coordsCount;
                newVertex[i] = new GeoVertex(new Vector3f((Vector3fc)pos), vertex.texU(), vertex.texV());
            }
            newQuads[j] = new GeoQuad(newVertex, new Vector3f((Vector3fc)quad.normal()), quad.direction());
        }
        if (coordsCount == 0) {
            return null;
        }
        avCoords[0] = avCoords[0] / (float)coordsCount;
        avCoords[1] = minCoords[1];
        avCoords[2] = avCoords[2] / (float)coordsCount;
        Vec3 offset = new Vec3((double)avCoords[0], (double)avCoords[1], (double)avCoords[2]);
        GeoCube newCube = new GeoCube(newQuads, geoCube.pivot().subtract(offset.scale(16.0)), geoCube.rotation(), geoCube.size(), geoCube.inflate(), geoCube.mirror());
        DeathAnimUtils.moveToOrigin(newCube, offset);
        IGeoCube iGeoCube = IGeoCube.of(newCube);
        iGeoCube.confluence$setMaxCoords(maxCoords);
        iGeoCube.confluence$setMinCoords(minCoords);
        return newCube;
    }

    public static void moveToOrigin(GeoCube cube, Vec3 centroid) {
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            for (GeoVertex vertex : quad.vertices()) {
                Vector3f pos = vertex.position();
                pos.set((double)pos.x - centroid.x, (double)pos.y - centroid.y, (double)pos.z - centroid.z);
            }
        }
    }

    public static void tellAddEntity(ClientLevel level, Entity entity) {
        toBeAdded.add((Pair<ResourceKey<Level>, Entity>)Pair.of((Object)level.dimension(), (Object)entity));
    }

    public static void tellDiscardEntity(Entity entity) {
        toBeDiscarded.add(entity);
    }

    public static <T extends LivingEntity> void dummyRender(LivingEntityRenderer<T, ?> livingRenderer, LivingEntity entity, PoseStack poseStack) {
        livingRenderer.render(entity, entity.getYRot(), 1.0f, poseStack, DummyMultiBufferSource.INSTANCE, 0);
    }

    public static void flattenBone(Collection<GeoBone> collection, GeoBone parent) {
        collection.add(parent);
        for (GeoBone child : parent.getChildBones()) {
            DeathAnimUtils.flattenBone(collection, child);
        }
    }

    public static void filterDeathBone(Collection<GeoBone> collection) {
        ArrayList<GeoBone> suffixed = new ArrayList<GeoBone>();
        for (GeoBone geoBone : collection) {
            if (!geoBone.getName().endsWith("_entire")) continue;
            suffixed.add(geoBone);
        }
        ArrayList<GeoBone> toRemove = new ArrayList<GeoBone>();
        for (GeoBone geoBone : suffixed) {
            for (GeoBone child : geoBone.getChildBones()) {
                DeathAnimUtils.flattenBone(toRemove, child);
            }
        }
        collection.removeAll(toRemove);
    }

    public static void livingDeath(LivingEntity entity) {
        block15: {
            Vec3 entityPos;
            float deathSpeed;
            Vec3 deathMotion;
            EntityRenderer renderer;
            ClientLevel level;
            block14: {
                Mob mob;
                Level level2 = entity.level();
                if (!(level2 instanceof ClientLevel)) {
                    return;
                }
                level = (ClientLevel)level2;
                DeathAnimUtils.tellDiscardEntity((Entity)entity);
                renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity);
                deathMotion = entity instanceof Mob && (mob = (Mob)entity).isNoAi() ? Vec3.ZERO : IEntity.of((Entity)entity).confluence$deathMotion(new Vec3[0]);
                if (deathMotion == null) {
                    deathMotion = entity.getDeltaMovement();
                }
                deathSpeed = (float)deathMotion.length();
                entityPos = entity.position();
                if (!(entity instanceof GeoAnimatable)) break block14;
                GeoAnimatable animatable = (GeoAnimatable)entity;
                if (!(renderer instanceof GeoEntityRenderer)) break block14;
                GeoEntityRenderer geoRenderer = (GeoEntityRenderer)renderer;
                PoseStack poseStack = new PoseStack();
                BakedGeoModel bakedGeoModel = geoRenderer.getGeoModel().getBakedModel(geoRenderer.getGeoModel().getModelResource(animatable, (GeoRenderer)geoRenderer));
                geoRenderer.preRender(poseStack, (Entity)entity, bakedGeoModel, null, null, false, 1.0f, 0, 0, 0);
                poseStack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
                poseStack.mulPose(Axis.YP.rotationDegrees(-entity.getYRot() + 180.0f));
                Matrix4f pose = poseStack.last().pose();
                ArrayList<GeoBone> bones = new ArrayList<GeoBone>();
                if (entity instanceof WallOfFlesh && geoRenderer instanceof WallOfFleshRenderer) {
                    WallOfFleshRenderer wofRenderer = (WallOfFleshRenderer)geoRenderer;
                    wofRenderer.getGeoModel().getBone("All").ifPresentOrElse(root -> DeathAnimUtils.flattenBone(bones, root), () -> bones.addAll(wofRenderer.getGeoModel().getAnimationProcessor().getRegisteredBones()));
                } else {
                    bones.addAll(geoRenderer.getGeoModel().getAnimationProcessor().getRegisteredBones());
                }
                for (GeoBone bone : bones) {
                    if (!"_death".equals(bone.getName())) continue;
                    bones.clear();
                    DeathAnimUtils.flattenBone(bones, bone);
                    break;
                }
                DeathAnimUtils.filterDeathBone(bones);
                block1: for (GeoBone bone : bones) {
                    GeoBone parent;
                    if (bone.isHidden() || Boolean.TRUE.equals(bone.shouldNeverRender()) || entity instanceof WallOfFlesh && level.random.nextInt(25) != 0) continue;
                    Vector3f boneOffset = new Vector3f(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                    ArrayList<Vector3f> rots = new ArrayList<Vector3f>();
                    rots.add(new Vector3f(bone.getRotX(), bone.getRotY(), bone.getRotZ()));
                    for (parent = bone.getParent(); parent != null; parent = parent.getParent()) {
                        if (parent.isHidingChildren()) continue block1;
                        rots.add(new Vector3f(parent.getRotX(), parent.getRotY(), parent.getRotZ()));
                        boneOffset.add(parent.getPosX(), parent.getPosY(), parent.getPosZ());
                    }
                    boneOffset.div(16.0f);
                    if (bone.getName().endsWith("_entire")) {
                        DeadBodyPartEntity part = new DeadBodyPartEntity((EntityType)ModEntities.BODY_PART.get(), (Level)level, (Entity)entity, bone, deathSpeed);
                        part.setPos(entityPos);
                        part.setDeltaMovement(deathMotion.offsetRandom(level.random, (float)(deathMotion.length() * 0.5 + 0.2)));
                        DeathAnimUtils.tellAddEntity(level, part);
                        continue;
                    }
                    for (GeoCube cube : bone.getCubes()) {
                        GeoCube copyCube = IGeoCube.of(cube).confluence$getCopy();
                        if (copyCube == null) continue;
                        DeadBodyPartEntity part = new DeadBodyPartEntity((EntityType)ModEntities.BODY_PART.get(), (Level)level, (Entity)entity, copyCube, deathSpeed);
                        float[] min = IGeoCube.of(copyCube).confluence$getMinCoords();
                        float[] max = IGeoCube.of(copyCube).confluence$getMaxCoords();
                        float xOffset = (min[0] + max[0]) / 2.0f + boneOffset.x;
                        float yOffset = min[1] + boneOffset.y;
                        float zOffset = (min[2] + max[2]) / 2.0f + boneOffset.z;
                        part.boneRots = rots;
                        ArrayList<Vector3f> bonePivots = new ArrayList<Vector3f>();
                        bonePivots.add(new Vector3f(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ()).sub((Vector3fc)new Vector3f(xOffset, yOffset, zOffset).mul(16.0f)).div(16.0f));
                        for (parent = bone.getParent(); parent != null; parent = parent.getParent()) {
                            bonePivots.add(new Vector3f(parent.getPivotX(), parent.getPivotY(), parent.getPivotZ()).sub((Vector3fc)new Vector3f(xOffset, yOffset, zOffset).mul(16.0f)).div(16.0f));
                        }
                        part.bonePivots = bonePivots;
                        part.boneOffset = boneOffset;
                        Vector4f transformed = pose.transform(new Vector4f(xOffset, yOffset, zOffset, 0.0f));
                        part.setPos(entityPos.add((double)transformed.x, (double)transformed.y, (double)transformed.z));
                        part.setDeltaMovement(deathMotion.offsetRandom(level.random, (float)(deathMotion.length() * 0.5 + 0.2)));
                        DeathAnimUtils.tellAddEntity(level, part);
                    }
                }
                break block15;
            }
            if (!(renderer instanceof LivingEntityRenderer)) break block15;
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            ModelPart rootModelPart = ILivingEntityRenderer.of(livingRenderer).confluence$getRootModelPart();
            if (rootModelPart == null) {
                return;
            }
            AntiPushPoseStack poseStack = new AntiPushPoseStack();
            poseStack.translate(entityPos.x, entityPos.y, entityPos.z);
            DeathAnimUtils.dummyRender(livingRenderer, entity, (PoseStack)poseStack);
            EntityModel entityModel = livingRenderer.getModel();
            if (entityModel instanceof AgeableHierarchicalModel) {
                AgeableHierarchicalModel model = (AgeableHierarchicalModel)entityModel;
                if (model.young) {
                    poseStack.scale(model.youngScaleFactor, model.youngScaleFactor, model.youngScaleFactor);
                    poseStack.translate(0.0f, model.bodyYOffset / 16.0f, 0.0f);
                }
            }
            Stack<Vector3f> rots = new Stack<Vector3f>();
            rots.push(new Vector3f());
            DeathAnimUtils.makePartRecursively(rootModelPart, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, null);
            for (RenderLayer layer : livingRenderer.layers) {
                if (!(layer instanceof HumanoidArmorLayer)) continue;
                HumanoidArmorLayer armorLayer = (HumanoidArmorLayer)layer;
                DeathAnimUtils.makeArmorPart(entity, armorLayer, EquipmentSlot.CHEST, poseStack, livingRenderer, level, deathSpeed, rots, deathMotion);
                DeathAnimUtils.makeArmorPart(entity, armorLayer, EquipmentSlot.HEAD, poseStack, livingRenderer, level, deathSpeed, rots, deathMotion);
                DeathAnimUtils.makeArmorPart(entity, armorLayer, EquipmentSlot.LEGS, poseStack, livingRenderer, level, deathSpeed, rots, deathMotion);
                DeathAnimUtils.makeArmorPart(entity, armorLayer, EquipmentSlot.FEET, poseStack, livingRenderer, level, deathSpeed, rots, deathMotion);
            }
        }
    }

    private static void offsetGeoArmor(LivingEntity entity, DeadBodyPartEntity part, ItemStack armorItemStack) {
        Vec3 pos = entity.position();
        double scale = entity.isBaby() ? 2.0 : 1.0;
        EquipmentSlot slot = ((Equipable)armorItemStack.getItem()).getEquipmentSlot();
        pos = switch (slot) {
            case EquipmentSlot.LEGS -> pos.add(0.0, 0.5 / scale, 0.0);
            case EquipmentSlot.CHEST -> pos.add(0.0, 1.0 / scale, 0.2 / scale);
            case EquipmentSlot.HEAD -> pos.add(0.0, 1.8 / scale, 0.0);
            default -> pos;
        };
        part.setPos(pos);
    }

    private static void makeGeoArmorPart(ClientLevel level, LivingEntity entity, ItemStack armorItemStack, float deathSpeed, Vec3 deathMotion, EntityModel<?> model) {
        EquipmentSlot slot = ((Equipable)armorItemStack.getItem()).getEquipmentSlot();
        float sideLength = entity.isBaby() && (slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET) ? 0.2f : 0.4f;
        DeadBodyPartEntity part = new DeadBodyPartEntity((EntityType)ModEntities.BODY_PART.get(), (Level)level, (Entity)entity, armorItemStack, deathSpeed, sideLength);
        DeathAnimUtils.offsetGeoArmor(entity, part, armorItemStack);
        part.setDeltaMovement(deathMotion.offsetRandom(level.random, (float)(deathMotion.length() * 0.5 + 0.2)));
        DeathAnimUtils.tellAddEntity(level, part);
    }

    private static void makeArmorPart(LivingEntity entity, HumanoidArmorLayer<?, ?, ?> armorLayer, EquipmentSlot slot, AntiPushPoseStack poseStack, LivingEntityRenderer<?, ?> livingRenderer, ClientLevel level, float deathSpeed, Stack<Vector3f> rots, Vec3 deathMotion) {
        Equipable equipable;
        ItemStack armorItemStack = entity.getItemBySlot(slot);
        Item armorItemStackItem = armorItemStack.getItem();
        boolean fromConfluence = ModUtils.isFromConfluence(BuiltInRegistries.ITEM, armorItemStackItem);
        if (ClientConfigs.goreEffect == ClientConfigs.GoreEffect.CONFLUENCE && !fromConfluence || ClientConfigs.goreEffect == ClientConfigs.GoreEffect.CONFLUENCE_VANILLA && !fromConfluence && !"minecraft".equals(BuiltInRegistries.ITEM.getKey((Object)armorItemStackItem).getNamespace()) || !(armorItemStackItem instanceof Equipable) || (equipable = (Equipable)armorItemStackItem).getEquipmentSlot() != slot) {
            return;
        }
        if (GeoRenderProvider.of((Item)armorItemStackItem).getGeoArmorRenderer(entity, armorItemStack, slot, null) != null) {
            DeathAnimUtils.makeGeoArmorPart(level, entity, armorItemStack, deathSpeed, deathMotion, livingRenderer.getModel());
        } else if (armorItemStackItem instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)armorItemStackItem;
            switch (slot) {
                case HEAD: {
                    DeathAnimUtils.makeHeadArmorPart(entity, armorLayer, armorItemStack, armorItem, poseStack, livingRenderer, level, deathSpeed, rots, deathMotion);
                    break;
                }
                case CHEST: {
                    DeathAnimUtils.makeChestArmorPart(entity, armorLayer, armorItemStack, armorItem, poseStack, livingRenderer, level, deathSpeed, rots, deathMotion);
                    break;
                }
                case LEGS: {
                    DeathAnimUtils.makeLegsArmorPart(entity, armorLayer, armorItemStack, armorItem, poseStack, livingRenderer, level, deathSpeed, rots, deathMotion);
                    break;
                }
                case FEET: {
                    DeathAnimUtils.makeFeetArmorPart(entity, armorLayer, armorItemStack, armorItem, poseStack, livingRenderer, level, deathSpeed, rots, deathMotion);
                }
            }
        }
    }

    private static void makeChestArmorPart(LivingEntity entity, HumanoidArmorLayer<?, ?, ?> armorLayer, ItemStack armorItemStack, ArmorItem armorItem, AntiPushPoseStack poseStack, LivingEntityRenderer<?, ?> livingRenderer, ClientLevel level, float deathSpeed, Stack<Vector3f> rots, Vec3 deathMotion) {
        if (armorLayer.outerModel == null) {
            return;
        }
        Model model = ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)armorItemStack, (EquipmentSlot)EquipmentSlot.CHEST, (HumanoidModel)armorLayer.outerModel);
        if (model instanceof HumanoidModel) {
            HumanoidModel outerModel = (HumanoidModel)model;
            outerModel.setAllVisible(true);
            ((HumanoidModel)armorLayer.getParentModel()).copyPropertiesTo(outerModel);
            for (ArmorMaterial.Layer materialLayer : ((ArmorMaterial)armorItem.getMaterial().value()).layers()) {
                ResourceLocation texture = ClientHooks.getArmorTexture((Entity)entity, (ItemStack)armorItemStack, (ArmorMaterial.Layer)materialLayer, (boolean)false, (EquipmentSlot)EquipmentSlot.CHEST);
                DeathAnimUtils.makePartRecursively(outerModel.body, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                DeathAnimUtils.makePartRecursively(outerModel.leftArm, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                DeathAnimUtils.makePartRecursively(outerModel.rightArm, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
            }
        }
    }

    private static void makeHeadArmorPart(LivingEntity entity, HumanoidArmorLayer<?, ?, ?> armorLayer, ItemStack armorItemStack, ArmorItem armorItem, AntiPushPoseStack poseStack, LivingEntityRenderer<?, ?> livingRenderer, ClientLevel level, float deathSpeed, Stack<Vector3f> rots, Vec3 deathMotion) {
        if (armorLayer.outerModel == null) {
            return;
        }
        Model model = ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)armorItemStack, (EquipmentSlot)EquipmentSlot.HEAD, (HumanoidModel)armorLayer.outerModel);
        if (model instanceof HumanoidModel) {
            HumanoidModel outerModel = (HumanoidModel)model;
            outerModel.setAllVisible(true);
            ((HumanoidModel)armorLayer.getParentModel()).copyPropertiesTo(outerModel);
            for (ArmorMaterial.Layer materialLayer : ((ArmorMaterial)armorItem.getMaterial().value()).layers()) {
                ResourceLocation texture = ClientHooks.getArmorTexture((Entity)entity, (ItemStack)armorItemStack, (ArmorMaterial.Layer)materialLayer, (boolean)false, (EquipmentSlot)EquipmentSlot.HEAD);
                DeathAnimUtils.makePartRecursively(outerModel.head, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                DeathAnimUtils.makePartRecursively(outerModel.hat, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
            }
        }
    }

    private static void makeLegsArmorPart(LivingEntity entity, HumanoidArmorLayer<?, ?, ?> armorLayer, ItemStack armorItemStack, ArmorItem armorItem, AntiPushPoseStack poseStack, LivingEntityRenderer<?, ?> livingRenderer, ClientLevel level, float deathSpeed, Stack<Vector3f> rots, Vec3 deathMotion) {
        if (armorLayer.innerModel == null) {
            return;
        }
        Model model = ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)armorItemStack, (EquipmentSlot)EquipmentSlot.LEGS, (HumanoidModel)armorLayer.innerModel);
        if (model instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            humanoidModel.setAllVisible(true);
            ((HumanoidModel)armorLayer.getParentModel()).copyPropertiesTo(humanoidModel);
            for (ArmorMaterial.Layer materialLayer : ((ArmorMaterial)armorItem.getMaterial().value()).layers()) {
                ResourceLocation texture = ClientHooks.getArmorTexture((Entity)entity, (ItemStack)armorItemStack, (ArmorMaterial.Layer)materialLayer, (boolean)true, (EquipmentSlot)EquipmentSlot.LEGS);
                DeathAnimUtils.makePartRecursively(humanoidModel.leftLeg, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                DeathAnimUtils.makePartRecursively(humanoidModel.rightLeg, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
            }
        }
    }

    private static void makeFeetArmorPart(LivingEntity entity, HumanoidArmorLayer<?, ?, ?> armorLayer, ItemStack armorItemStack, ArmorItem armorItem, AntiPushPoseStack poseStack, LivingEntityRenderer<?, ?> livingRenderer, ClientLevel level, float deathSpeed, Stack<Vector3f> rots, Vec3 deathMotion) {
        if (armorLayer.outerModel == null) {
            return;
        }
        Model model = ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)armorItemStack, (EquipmentSlot)EquipmentSlot.FEET, (HumanoidModel)armorLayer.outerModel);
        if (model instanceof HumanoidModel) {
            HumanoidModel outerModel = (HumanoidModel)model;
            outerModel.setAllVisible(true);
            ((HumanoidModel)armorLayer.getParentModel()).copyPropertiesTo(outerModel);
            for (ArmorMaterial.Layer materialLayer : ((ArmorMaterial)armorItem.getMaterial().value()).layers()) {
                ResourceLocation texture = ClientHooks.getArmorTexture((Entity)entity, (ItemStack)armorItemStack, (ArmorMaterial.Layer)materialLayer, (boolean)false, (EquipmentSlot)EquipmentSlot.FEET);
                DeathAnimUtils.makePartRecursively(outerModel.leftLeg, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                DeathAnimUtils.makePartRecursively(outerModel.rightLeg, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
            }
        }
    }

    private static void makePartRecursively(ModelPart modelPart, AntiPushPoseStack poseStack, LivingEntityRenderer<?, ?> renderer, ClientLevel level, Entity entity, float deathSpeed, Stack<Vector3f> rots, Vec3 deathMotion, ResourceLocation texture) {
        Object object;
        if (!modelPart.visible || modelPart.skipDraw) {
            return;
        }
        poseStack.pushPose(true);
        if (renderer.getModel().young && (object = renderer.getModel()) instanceof AgeableListModelAccessor) {
            float scale;
            AgeableListModelAccessor model = (AgeableListModelAccessor)object;
            for (ModelPart bodyPart : model.callBodyParts()) {
                if (modelPart != bodyPart) continue;
                scale = 1.0f / model.getBabyBodyScale();
                poseStack.scale(scale, scale, scale);
                poseStack.translate(0.0f, model.getBodyYOffset() / 16.0f, 0.0f);
                break;
            }
            for (ModelPart headPart : model.callHeadParts()) {
                if (modelPart != headPart) continue;
                if (model.getScaleHead()) {
                    scale = 1.5f / model.getBabyHeadScale();
                    poseStack.scale(scale, scale, scale);
                }
                poseStack.translate(0.0f, model.getBabyYHeadOffset() / 16.0f, model.getBabyZHeadOffset() / 16.0f);
                break;
            }
        }
        modelPart.translateAndRotate((PoseStack)poseStack);
        Vector3f modelRot = rots.peek();
        Matrix4f pose = poseStack.last().pose();
        Transformation transformation = new Transformation(pose);
        Vector3f scale = transformation.getScale();
        for (ModelPart.Cube cube : modelPart.cubes) {
            float minX = cube.minX;
            float minY = cube.minY;
            float minZ = cube.minZ;
            float maxX = cube.maxX;
            float maxY = cube.maxY;
            float maxZ = cube.maxZ;
            float centerY = (minY + maxY) / 2.0f / 16.0f;
            float xSize = maxX - minX;
            float ySize = maxY - minY;
            float zSize = maxZ - minZ;
            float min = xSize;
            float finalScale = scale.x;
            if (ySize < min) {
                min = ySize;
                finalScale = scale.y;
            }
            if (zSize < min) {
                min = zSize;
                finalScale = scale.z;
            }
            if ((min /= 16.0f) < 0.0625f) {
                min = 0.0625f;
                finalScale = 1.0f;
            }
            float scaledMin = min * finalScale;
            DeadBodyPartEntity part = new DeadBodyPartEntity((EntityType)ModEntities.BODY_PART.get(), (Level)level, entity, cube, deathSpeed, scaledMin);
            part.texture = texture;
            float xOffset = (minX + maxX) / 2.0f / 16.0f;
            float zOffset = (minZ + maxZ) / 2.0f / 16.0f;
            Vector4f transformedCentroid = pose.transform(new Vector4f(xOffset, centerY, zOffset, 1.0f));
            float yOffset = min / 2.0f - scaledMin / 2.0f;
            Vector4f transformedOffset = pose.transform(new Vector4f(xOffset, centerY, zOffset, 0.0f));
            part.setPos(transformedCentroid.x, transformedCentroid.y - min / 2.0f + yOffset, transformedCentroid.z);
            part.setDeltaMovement(deathMotion.offsetRandom(level.random, (float)(deathMotion.length() * 0.4 + 0.1)));
            if (texture == null) {
                modelRot.add(modelPart.xRot, modelPart.yRot, modelPart.zRot);
            }
            part.modelPartRot = modelRot;
            part.xOffset = transformedOffset.x;
            part.yOffset = transformedOffset.y - scaledMin / 2.0f;
            part.zOffset = transformedOffset.z;
            part.modelPart = modelPart;
            DeathAnimUtils.tellAddEntity(level, part);
        }
        for (Map.Entry entry : modelPart.children.entrySet()) {
            String childName = (String)entry.getKey();
            ModelPart child = (ModelPart)entry.getValue();
            if ("cloak".equals(childName)) continue;
            poseStack.pushPose(true);
            Vector3f newRot = new Vector3f((Vector3fc)modelRot);
            rots.push(newRot);
            DeathAnimUtils.makePartRecursively(child, poseStack, renderer, level, entity, deathSpeed, rots, deathMotion, texture);
            rots.pop();
            poseStack.popPose(true);
        }
        poseStack.popPose(true);
    }
}

