/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.common.init.ModEnchantments;
import org.confluence.mod.util.FloatSupplier;
import org.confluence.mod.util.PlayerUtils;

public final class EnchantmentUtils {
    public static final EquipmentSlot[] HUMANOID_ARMOR = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final EquipmentSlot[] HUMANOID_ARMOR_AND_MAIN_HAND = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.MAINHAND};

    public static float processManaRegeneration(ServerPlayer player) {
        MutableFloat value = new MutableFloat(1.0f);
        for (EquipmentSlot slot : HUMANOID_ARMOR_AND_MAIN_HAND) {
            EnchantmentHelper.runIterationOnItem((ItemStack)player.getItemBySlot(slot), (enchantment, level) -> {
                List effects = ((Enchantment)enchantment.value()).getEffects((DataComponentType)ModEnchantments.EffectComponentTypes.MANA_REGENERATION.get());
                LootContext context = Enchantment.entityContext((ServerLevel)player.serverLevel(), (int)level, (Entity)player, (Vec3)player.position());
                Enchantment.applyEffects((List)effects, (LootContext)context, effect -> value.setValue(effect.process(level, player.getRandom(), value.floatValue())));
            });
        }
        return value.floatValue();
    }

    public static FloatSupplier processEfficientMagic(FloatSupplier sup, ServerPlayer player) {
        if (EnchantmentHelper.has((ItemStack)player.getMainHandItem(), (DataComponentType)((DataComponentType)ModEnchantments.EffectComponentTypes.EFFICIENT_MAGIC.get()))) {
            ManaStorage manaStorage = ManaStorage.of((LivingEntity)player);
            return () -> sup.getAsFloat() * Mth.lerp((float)(manaStorage.getCurrentMana() / (float)manaStorage.getMaxMana()), (float)0.5f, (float)1.0f);
        }
        return sup;
    }

    public static void repairPlayerItems(ServerPlayer player, float consumedManaAmount) {
        Optional optional = EnchantmentHelper.getRandomItemWith((DataComponentType)((DataComponentType)ModEnchantments.EffectComponentTypes.MANA_MENDING.get()), (LivingEntity)player, ItemStack::isDamaged);
        if (optional.isPresent()) {
            ItemStack stack = ((EnchantedItemInUse)optional.get()).itemStack();
            MutableFloat threshold = new MutableFloat(10.0f);
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyItemFilteredCount((DataComponentType)ModEnchantments.EffectComponentTypes.MANA_MENDING.get(), player.serverLevel(), level, stack, threshold));
            int delta = (int)(consumedManaAmount - Math.max(0.0f, threshold.floatValue()));
            if (delta > 1) {
                stack.setDamageValue(stack.getDamageValue() - delta);
            }
        }
    }

    public static void dropsStar(ServerPlayer player, LivingEntity victim, DamageSource damageSource) {
        ItemStack itemStack = player.getMainHandItem();
        EnchantedItemInUse item = new EnchantedItemInUse(itemStack, EquipmentSlot.MAINHAND, (LivingEntity)player);
        EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (enchantment, level) -> {
            for (TargetedConditionalEffect effect : ((Enchantment)enchantment.value()).getEffects((DataComponentType)ModEnchantments.EffectComponentTypes.ATTACK_DROPS_MANA.get())) {
                if (effect.enchanted() != EnchantmentTarget.ATTACKER) continue;
                Enchantment.doPostAttack((TargetedConditionalEffect)effect, (ServerLevel)player.serverLevel(), (int)level, (EnchantedItemInUse)item, (Entity)victim, (DamageSource)damageSource);
            }
        });
    }

    public static int processManaSicknessDuration(ServerPlayer player, int duration) {
        MutableFloat ratio = new MutableFloat(1.0f);
        ItemStack itemStack = player.getMainHandItem();
        EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyEntityFilteredValue((DataComponentType)ModEnchantments.EffectComponentTypes.MANA_SICKNESS_DURATION_REDUCE.get(), player.serverLevel(), level, itemStack, (Entity)player, ratio));
        return (int)((float)duration * Math.max(0.0f, ratio.floatValue()));
    }

    public static float processManaProtection(ServerPlayer player, DamageSource damageSource, float amount) {
        float clamp;
        if (damageSource.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return amount;
        }
        MutableFloat ratio = new MutableFloat();
        for (EquipmentSlot slot : HUMANOID_ARMOR) {
            ItemStack itemStack = player.getItemBySlot(slot);
            EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyDamageFilteredValue((DataComponentType)ModEnchantments.EffectComponentTypes.MANA_PROTECTION.get(), player.serverLevel(), level, itemStack, (Entity)player, damageSource, ratio));
        }
        if (ratio.floatValue() <= 0.0f) {
            return amount;
        }
        ManaStorage manaStorage = ManaStorage.of((LivingEntity)player);
        if (manaStorage.forceExtractMana(() -> EnchantmentUtils.lambda$processManaProtection$7(manaStorage, clamp = 1.0f - Mth.clamp((float)ratio.floatValue(), (float)0.0f, (float)0.8f)))) {
            PlayerUtils.syncMana2Client(player, manaStorage);
            return amount * clamp;
        }
        return amount;
    }

    public static float processMagicAttack(ServerPlayer player, DamageSource damageSource, float amount) {
        ItemStack itemStack = player.getMainHandItem();
        MutableFloat lm = new MutableFloat();
        EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyDamageFilteredValue((DataComponentType)ModEnchantments.EffectComponentTypes.LESS_MANA_MORE_ATTACK.get(), player.serverLevel(), level, itemStack, (Entity)player, damageSource, lm));
        MutableFloat mm = new MutableFloat();
        EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (enchantment, level) -> ((Enchantment)enchantment.value()).modifyDamageFilteredValue((DataComponentType)ModEnchantments.EffectComponentTypes.MORE_MANA_MORE_ATTACK.get(), player.serverLevel(), level, itemStack, (Entity)player, damageSource, mm));
        if (lm.floatValue() > 0.0f || mm.floatValue() > 0.0f) {
            ManaStorage manaStorage = ManaStorage.of((LivingEntity)player);
            float ratio = manaStorage.getCurrentMana() / (float)manaStorage.getMaxMana();
            return amount + amount * ((1.0f - ratio) * lm.floatValue() + ratio * mm.floatValue());
        }
        return amount;
    }

    public static ItemStack enchantedBook(HolderLookup.RegistryLookup<Enchantment> registryLookup, ResourceKey<Enchantment> key, int level) {
        ItemStack book = Items.ENCHANTED_BOOK.getDefaultInstance();
        book.enchant((Holder)registryLookup.getOrThrow(key), level);
        return book;
    }

    private static /* synthetic */ float lambda$processManaProtection$7(ManaStorage manaStorage, float clamp) {
        return (float)manaStorage.getMaxMana() * clamp;
    }
}

