/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.common.NeoForgeConfig;
import org.confluence.mod.common.component.prefix.PrefixComponent;
import org.confluence.mod.common.component.prefix.PrefixType;
import org.confluence.mod.util.PrefixUtils;

public class ModAttributeUtils {
    public static void addPrefixTooltips(AddAttributeTooltipsEvent event) {
        PrefixComponent prefix = PrefixUtils.getPrefix(event.getStack());
        if (prefix == null) {
            return;
        }
        if (prefix.type() == PrefixType.MAGIC) {
            if ((double)prefix.manaCost() != 0.0) {
                boolean positive = (double)prefix.manaCost() > 0.0;
                String format = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(prefix.manaCost() * (float)(positive ? 100 : -100));
                MutableComponent component = Component.translatable((String)"prefix.confluence.tooltip.mana_cost");
                if (event.getContext().flag().isAdvanced() && ((Boolean)NeoForgeConfig.COMMON.attributeAdvancedTooltipDebugInfo.get()).booleanValue()) {
                    String valueStr = ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(1.0f + prefix.manaCost());
                    component.append((Component)Component.literal((String)(" [x" + valueStr + "]")).withStyle(ChatFormatting.GRAY));
                }
                event.addTooltipLines(new Component[]{Component.translatable((String)("prefix.confluence.tooltip." + (positive ? "plus" : "take")), (Object[])new Object[]{format, component}).withStyle(positive ? ChatFormatting.RED : ChatFormatting.BLUE)});
            }
        } else if (prefix.type() == PrefixType.ACCESSORY && prefix.additionalMana() > 0) {
            MutableComponent component = Component.translatable((String)"prefix.confluence.tooltip.additional_mana");
            if (event.getContext().flag().isAdvanced() && ((Boolean)NeoForgeConfig.COMMON.attributeAdvancedTooltipDebugInfo.get()).booleanValue()) {
                component.append((Component)Component.literal((String)(" [+" + prefix.additionalMana() + "]")).withStyle(ChatFormatting.GRAY));
            }
            event.addTooltipLines(new Component[]{Component.translatable((String)"prefix.confluence.tooltip.add", (Object[])new Object[]{prefix.additionalMana(), component}).withStyle(ChatFormatting.BLUE)});
        }
    }
}

