/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.api.event.EffectSwitchableCheckEvent;
import org.confluence.mod.common.block.common.AetheriumCauldronBlock;
import org.confluence.mod.common.block.common.HoneyCauldronBlock;
import org.confluence.mod.common.component.LootComponent;
import org.confluence.mod.common.data.saved.GamePhase;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.data.saved.MeteoriteTracker;
import org.confluence.mod.common.gameevent.SlimeRainGameEvent;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.ConsumableItems;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.init.item.PotionItems;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.mod.common.item.common.TreasureBagItem;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.terra_curio.common.init.TCEffects;
import org.confluence.terraentity.entity.boss.AbstractTerraBossBase;
import org.confluence.terraentity.init.entity.TEBossEntities;
import org.confluence.terraentity.init.entity.TEMonsterEntities;
import org.confluence.terraentity.utils.TEUtils;
import org.jetbrains.annotations.Nullable;

public final class ModUtils {
    public static final Set<String> CONFLUENCE_NAMESPACES = Set.of("confluence", "terra_curio", "terra_entity", "terra_guns");

    public static void dropMoney(int amount, double x, double y, double z, Level level) {
        int copper_count = amount % 100;
        int i = (amount - copper_count) / 100;
        int silver_count = i % 100;
        int j = (i - silver_count) / 100;
        int golden_count = j % 100;
        int k = (j - golden_count) / 100;
        LibUtils.createItemEntity((Item)((Item)ModItems.COPPER_COIN.get()), (int)copper_count, (double)x, (double)y, (double)z, (Level)level, (int)0);
        LibUtils.createItemEntity((Item)((Item)ModItems.SILVER_COIN.get()), (int)silver_count, (double)x, (double)y, (double)z, (Level)level, (int)0);
        LibUtils.createItemEntity((Item)((Item)ModItems.GOLD_COIN.get()), (int)golden_count, (double)x, (double)y, (double)z, (Level)level, (int)0);
        LibUtils.createItemEntity((Item)((Item)ModItems.PLATINUM_COIN.get()), (int)k, (double)x, (double)y, (double)z, (Level)level, (int)0);
    }

    public static void dropMoney(long amount, double x, double y, double z, Level level) {
        while (amount > 0x3F3F3F3FL) {
            ModUtils.dropMoney(0x3F3F3F3F, x, y, z, level);
            amount -= 0x3F3F3F3FL;
        }
        ModUtils.dropMoney((int)amount, x, y, z, level);
    }

    public static <T> boolean isFromConfluence(Registry<T> registry, T obj) {
        ResourceLocation key = registry.getKey(obj);
        return key != null && CONFLUENCE_NAMESPACES.contains(key.getNamespace());
    }

    public static boolean isWaterBottle(ItemStack itemStack) {
        return itemStack.is(PotionItems.BOTTLED_WATER) || ((PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).is(Potions.WATER);
    }

    public static void summonBoss(ServerLevel level, BlockPos pos, AbstractTerraBossBase boss, boolean onSurface) {
        double x = (double)pos.getX() + 0.5 + (double)Mth.randomBetweenInclusive((RandomSource)level.random, (int)-50, (int)50);
        double z = (double)pos.getZ() + 0.5 + (double)Mth.randomBetweenInclusive((RandomSource)level.random, (int)-50, (int)50);
        double y = (double)(onSurface ? level.getHeight(Heightmap.Types.MOTION_BLOCKING, Mth.floor((double)x), Mth.floor((double)z)) : pos.getY()) + 0.5;
        if (Math.abs((double)pos.getY() - y) > 50.0) {
            y = pos.getY();
        }
        boss.setPos(x, y, z);
        if (TEUtils.internalSpawnEntity((Entity)boss, (ServerLevel)level)) {
            level.addFreshEntityWithPassengers((Entity)boss);
        }
    }

    public static void summonBoss(ServerLevel level, BlockPos pos, AbstractTerraBossBase boss) {
        ModUtils.summonBoss(level, pos, boss, true);
    }

    @Nullable
    public static BlockState getLeadAnvilDamage(BlockState state, DirectionProperty FACING) {
        Block block = state.getBlock();
        if (block == FunctionalBlocks.LEAD_ANVIL.get()) {
            return (BlockState)((AnvilBlock)FunctionalBlocks.CHIPPED_LEAD_ANVIL.get()).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
        }
        if (block == FunctionalBlocks.CHIPPED_LEAD_ANVIL.get()) {
            return (BlockState)((AnvilBlock)FunctionalBlocks.DAMAGED_LEAD_ANVIL.get()).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
        }
        if (block == FunctionalBlocks.DAMAGED_LEAD_ANVIL.get()) {
            return null;
        }
        return state;
    }

    public static void bossDeath(ServerLevel level, LivingEntity living) {
        boolean isEaterOfWorlds;
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            return;
        }
        EntityType type = living.getType();
        KillBoard.INSTANCE.defeat(type);
        boolean bl = isEaterOfWorlds = type == TEBossEntities.EATER_OF_WORLDS.get();
        if (isEaterOfWorlds || type == TEBossEntities.BRAIN_OF_CTHULHU.get()) {
            if (LibDateUtils.isWithinDayTime((int)LibDateUtils._00$00, (int)LibDateUtils._04$30, (Level)level)) {
                MeteoriteTracker.INSTANCE.spawnAtNextNight = true;
            } else if (!MeteoriteTracker.INSTANCE.spawnAtNextNight) {
                MeteoriteTracker.INSTANCE.spawnAtNextNight = level.random.nextBoolean();
            }
        }
        boolean stickySituation = type == TEBossEntities.KING_SLIME.get() && SlimeRainGameEvent.INSTANCE.started();
        boolean is$WallOrHill$OfFlesh = type == TEBossEntities.WALL_OF_FLESH.get() || type == TEBossEntities.HILL_OF_FLESH.get();
        ResourceKey dimension = living.level().dimension();
        level.players().stream().filter(player -> player.level().dimension() == dimension).forEach(player -> {
            TreasureBagItem.createItemEntity(living, player);
            if (isEaterOfWorlds) {
                AchievementUtils.awardAchievement(player, "worm_fodder");
            } else if (stickySituation) {
                AchievementUtils.awardAchievement(player, "sticky_situation");
            } else if (is$WallOrHill$OfFlesh) {
                AchievementUtils.awardAchievement(player, "still_hungry");
            }
        });
    }

    public static void enemyDropMoney(LivingEntity living, ServerLevel level) {
        double amount = ModUtils.getLivingBaseMoneyDrops(living, (Level)level);
        if (living.hasEffect(ModEffects.MIDAS)) {
            amount *= Mth.nextDouble((RandomSource)living.getRandom(), (double)1.1, (double)1.49);
        }
        if (IMinecraftServer.isHardmode(level.getServer())) {
            amount *= 1.6;
        }
        if (KillBoard.INSTANCE.getGamePhase().isAtLeast(GamePhase.PLANTERA)) {
            amount *= 1.5;
        }
        ModUtils.dropMoney((int)amount, living.getX(), living.getEyeY() - 0.3, living.getZ(), (Level)level);
    }

    public static double getLivingBaseMoneyDrops(LivingEntity living, Level level) {
        AttributeInstance attack = living.getAttribute(Attributes.ATTACK_DAMAGE);
        AttributeInstance armor = living.getAttribute(Attributes.ARMOR);
        AttributeInstance knockbackResistance = living.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        double healthFactor = (double)living.getMaxHealth() * 0.15;
        double attackFactor = attack == null ? 0.0 : attack.getValue() * 0.25;
        double armorFactor = armor == null ? 0.0 : armor.getValue() * 0.1;
        double knockbackResistanceFactor = knockbackResistance == null ? 10.0 : (1.0 + knockbackResistance.getValue()) * 10.0;
        double difficultyFactor = (double)level.getCurrentDifficultyAt(living.blockPosition()).getEffectiveDifficulty() * 0.5;
        return Math.min((double)Math.round((healthFactor + attackFactor + armorFactor + knockbackResistanceFactor) * difficultyFactor) * 7.0, 100000.0);
    }

    public static void applyBrainOfCthulhuDebuff(ServerLevel level, @Nullable Entity attacker, LivingEntity living) {
        EntityType type;
        if (attacker != null && LibUtils.isAtLeastExpert((Level)level, (BlockPos)living.blockPosition()) && ((type = attacker.getType()) == TEMonsterEntities.VISUAL_NEURON.get() || type == TEBossEntities.BRAIN_OF_CTHULHU.get() && attacker.getRandom().nextFloat() < 0.3333f)) {
            float min;
            DeferredHolder<MobEffect, MobEffect> debuff;
            boolean master = LibUtils.isMaster((Level)level, (BlockPos)living.blockPosition());
            int i = attacker.getRandom().nextInt(81);
            if (i < 11) {
                debuff = MobEffects.POISON;
                min = master ? 6.56f : 5.25f;
            } else if (i < 22) {
                debuff = MobEffects.BLINDNESS;
                min = master ? 3.75f : 3.0f;
            } else if (i < 24) {
                debuff = ModEffects.CURSED;
                min = master ? 0.94f : 0.75f;
            } else if (i < 35) {
                debuff = ModEffects.BLEEDING;
                min = master ? 9.38f : 7.5f;
            } else if (i < 37) {
                debuff = TCEffects.CONFUSED;
                min = master ? 1.88f : 1.5f;
            } else if (i < 48) {
                debuff = MobEffects.MOVEMENT_SLOWDOWN;
                min = master ? 6.56f : 5.25f;
            } else if (i < 59) {
                debuff = MobEffects.WEAKNESS;
                min = master ? 14.06f : 11.25f;
            } else if (i < 70) {
                debuff = ModEffects.SILENCED;
                min = master ? 1.88f : 1.5f;
            } else {
                debuff = ModEffects.BROKEN_ARMOR;
                min = master ? 12.19f : 9.75f;
            }
            living.addEffect(new MobEffectInstance((Holder)debuff, (int)((attacker.getRandom().nextFloat() * min + min) * 20.0f)));
        }
    }

    public static void applyCursedSkullDebuff(@Nullable Entity attacker, LivingEntity living) {
        if (attacker != null && attacker.getType() == TEMonsterEntities.CURSED_SKULL.get() && attacker.getRandom().nextFloat() < 0.33f) {
            living.addEffect(new MobEffectInstance(ModEffects.CURSED, 80));
        }
    }

    public static boolean canHitEntity(@Nullable Entity target, @Nullable Entity owner) {
        if (target == null || target.isRemoved()) {
            return false;
        }
        if (owner == target || !target.isAttackable() || !target.canBeHitByProjectile() || target instanceof ArmorStand) {
            return false;
        }
        return owner == null || !owner.isPassengerOfSameVehicle(target);
    }

    public static Component formatPrice(int price) {
        int platinum = 0;
        int gold = 0;
        int silver = 0;
        if (price >= 1000000) {
            platinum = price / 1000000;
            price -= platinum * 1000000;
        }
        if (price >= 10000) {
            gold = price / 10000;
            price -= gold * 10000;
        }
        if (price >= 100) {
            silver = price / 100;
            price -= silver * 100;
        }
        int copper = price;
        MutableComponent cmp = Component.empty();
        if (platinum > 0) {
            cmp.append((Component)Component.literal((String)(platinum + " ")).withColor(-4996668)).append((Component)Component.translatable((String)"tooltip.price.platinum").withColor(-4996668));
        }
        if (gold > 0) {
            cmp.append((Component)Component.literal((String)(gold + " ")).withColor(-3891380)).append((Component)Component.translatable((String)"tooltip.price.gold").withColor(-3891380));
        }
        if (silver > 0) {
            cmp.append((Component)Component.literal((String)(silver + " ")).withColor(-4532777)).append((Component)Component.translatable((String)"tooltip.price.silver").withColor(-4532777));
        }
        if (copper > 0) {
            cmp.append((Component)Component.literal((String)(copper + " ")).withColor(-3837899)).append((Component)Component.translatable((String)"tooltip.price.copper").withColor(-3837899));
        }
        return cmp;
    }

    public static boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        boolean supportedItem = stack.is(((Enchantment)enchantment.value()).definition().supportedItems());
        if (stack.has(DataComponents.UNBREAKABLE)) {
            return supportedItem && !enchantment.is(Enchantments.UNBREAKING) && !enchantment.is(Enchantments.MENDING);
        }
        return supportedItem;
    }

    public static boolean isRainingAt(Level level, BlockPos pos) {
        if (!level.isRaining()) {
            return false;
        }
        if (!level.canSeeSky(pos)) {
            return false;
        }
        if (level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() > pos.getY()) {
            return false;
        }
        return ((Biome)level.getBiome(pos).value()).getPrecipitationAt(pos) == Biome.Precipitation.RAIN;
    }

    public static void makeItemAntigravity(ItemEntity entity) {
        if (entity.getItem().is(ModTags.Items.ANTIGRAVITY)) {
            entity.setNoGravity(true);
        }
    }

    public static boolean couldAnvilForceMerge(ItemStack itemStack) {
        return ModUtils.isFromConfluence(BuiltInRegistries.ITEM, itemStack.getItem());
    }

    public static void registerCauldronInteractions() {
        CauldronInteraction.INTERACTIONS.values().forEach(map -> {
            Map interactionMap = map.map();
            interactionMap.put((Item)ToolItems.BOTTOMLESS_WATER_BUCKET.get(), CauldronInteraction.FILL_WATER);
            interactionMap.put((Item)ToolItems.BOTTOMLESS_LAVA_BUCKET.get(), CauldronInteraction.FILL_LAVA);
            interactionMap.put((Item)ToolItems.BOTTOMLESS_HONEY_BUCKET.get(), HoneyCauldronBlock.FILL_HONEY);
            interactionMap.put((Item)ToolItems.BOTTOMLESS_SHIMMER_BUCKET.get(), AetheriumCauldronBlock.FILL_AETHERIUM);
            interactionMap.put((Item)ToolItems.HONEY_BUCKET.get(), HoneyCauldronBlock.FILL_HONEY);
            interactionMap.put(NatureBlocks.AETHERIUM_BLOCK.asItem(), AetheriumCauldronBlock.FILL_AETHERIUM);
        });
        CauldronInteraction.EMPTY.map().put((Item)PotionItems.BOTTLED_WATER.get(), (state, level, pos, player, hand, stack) -> {
            if (!level.isClientSide) {
                Item item = stack.getItem();
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)PotionItems.BOTTLE.toStack()));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                level.setBlockAndUpdate(pos, Blocks.WATER_CAULDRON.defaultBlockState());
                level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
        CauldronInteraction.WATER.map().put((Item)PotionItems.BOTTLE.get(), (state, level, pos, player, hand, stack) -> {
            if (!level.isClientSide) {
                Item item = stack.getItem();
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)PotionItems.BOTTLED_WATER.toStack()));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
                level.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
        CauldronInteraction.WATER.map().put((Item)PotionItems.BOTTLED_WATER.get(), (state, level, pos, player, hand, stack) -> {
            if ((Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) == 3) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (!level.isClientSide) {
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)PotionItems.BOTTLE.toStack()));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LayeredCauldronBlock.LEVEL));
                level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
    }

    public static boolean isDebuff(MobEffectInstance instance) {
        return ((MobEffect)instance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL && !instance.getCures().contains(ModEffects.CANNOT_REMOVE_BY_NURSE);
    }

    public static boolean isSwitchableEffect(MobEffectInstance instance) {
        MobEffect effect = (MobEffect)instance.getEffect().value();
        boolean switchable = effect == TCEffects.GRAVITATION.get() ? instance.getAmplifier() <= 0 : effect.isBeneficial();
        return ((EffectSwitchableCheckEvent)NeoForge.EVENT_BUS.post((Event)new EffectSwitchableCheckEvent(instance, switchable))).isSwitchable();
    }

    public static boolean useKey(ItemStack carried, ItemStack onSlot, Player player) {
        if (carried.is(ToolItems.GOLDEN_DUNGEON_KEY) && onSlot.is(ConsumableItems.GOLDEN_LOCK_BOX) || carried.is(ToolItems.SHADOW_KEY) && onSlot.is(ConsumableItems.OBSIDIAN_LOCK_BOX)) {
            ServerPlayer serverPlayer;
            if (player instanceof ServerPlayer && LootComponent.open(serverPlayer = (ServerPlayer)player, onSlot) && !serverPlayer.hasInfiniteMaterials()) {
                if (carried.is(ToolItems.GOLDEN_DUNGEON_KEY)) {
                    carried.shrink(1);
                }
                onSlot.shrink(1);
            }
            return true;
        }
        return false;
    }
}

