/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.network.s2c.TerraStyleExplosionPacketS2C;
import org.jetbrains.annotations.Nullable;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.data.molang.MolangExp;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class TerraStyleExplosion
extends Explosion {
    private static final ResourceLocation PARTICLE_ID = Confluence.asResource("explosion");

    public TerraStyleExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, Explosion.BlockInteraction blockInteraction) {
        super(level, source, damageSource, damageCalculator, x, y, z, radius, false, blockInteraction, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE);
    }

    public void explode() {
        Vec3 center = new Vec3(this.x, this.y, this.z);
        this.level.gameEvent(this.source, (Holder)GameEvent.EXPLODE, center);
        float obsidianBasedExplosionResistance = ModBlocks.getObsidianBasedExplosionResistance(0.0f);
        BlockPos origin = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        AABB area = new AABB(this.x - (double)this.radius, this.y - (double)this.radius, this.z - (double)this.radius, this.x + (double)this.radius, this.y + (double)this.radius, this.z + (double)this.radius);
        double radiusP2 = this.radius * this.radius;
        double inner = Mth.square((int)Mth.floor((float)(this.radius - 0.5f)));
        BlockPos.betweenClosedStream((AABB)area).forEach(pos -> {
            double sqr = pos.distSqr((Vec3i)origin);
            if (this.level.isInWorldBounds(pos) && sqr <= radiusP2) {
                if (!this.level.getFluidState(pos).isEmpty()) {
                    return;
                }
                BlockState blockState = this.level.getBlockState(pos);
                this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, pos, blockState, Fluids.EMPTY.defaultFluidState()).ifPresent(resistance -> {
                    if (resistance.floatValue() < obsidianBasedExplosionResistance && (sqr < inner || this.random.nextFloat() < 0.8f)) {
                        this.toBlow.add((Object)pos.immutable());
                    }
                });
            }
        });
        List list = this.level.getEntities(this.source, area);
        EventHooks.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)(this.radius + this.radius));
        for (Entity entity : list) {
            Player player;
            if (entity.ignoreExplosion((Explosion)this)) continue;
            if (this.damageCalculator.shouldDamageEntity((Explosion)this, entity)) {
                entity.hurt(this.damageSource, Math.min(this.damageCalculator.getEntityDamageAmount((Explosion)this, entity), this.radius * 10.0f));
            }
            if (!(!(entity instanceof Player) || (player = (Player)entity).isSpectator() || player.isCreative() && player.getAbilities().flying)) {
                this.hitPlayers.put(player, Vec3.ZERO);
            }
            entity.onExplosionHit(this.source);
        }
    }

    public void finalizeExplosion(boolean spawnParticles) {
        if (!this.level.isClientSide && this.interactsWithBlocks()) {
            this.level.getProfiler().push("explosion_blocks");
            ArrayList drops = new ArrayList();
            Util.shuffle((List)this.toBlow, (RandomSource)this.level.random);
            for (BlockPos blockpos : this.toBlow) {
                this.level.getBlockState(blockpos).onExplosionHit(this.level, blockpos, (Explosion)this, (stack, pos) -> TerraStyleExplosion.addOrAppendStack((List)drops, (ItemStack)stack, (BlockPos)pos));
            }
            for (Pair pair : drops) {
                Block.popResource((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
            this.level.getProfiler().pop();
        }
    }

    public static void handleClientExplode(Level level, double x, double y, double z, float radius) {
        level.playLocalSound(x, y, z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f) * 0.7f, false);
        PSGameClient.LOADER.addEmitter(new ParticleEmitter(level, new Vec3(x, y, z), PARTICLE_ID, new MolangExp("variable.radius", (double)radius)), false);
    }

    public static Explosion terraExplode(ServerLevel level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, Level.ExplosionInteraction explosionInteraction) {
        if (((Boolean)CommonConfigs.TERRA_STYLE_EXPLOSION.get()).booleanValue()) {
            Explosion.BlockInteraction blockInteraction = switch (explosionInteraction) {
                default -> throw new MatchException(null, null);
                case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
                case Level.ExplosionInteraction.BLOCK -> TerraStyleExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY);
                case Level.ExplosionInteraction.MOB -> {
                    if (EventHooks.canEntityGrief((Level)level, (Entity)source)) {
                        yield TerraStyleExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_MOB_EXPLOSION_DROP_DECAY);
                    }
                    yield Explosion.BlockInteraction.KEEP;
                }
                case Level.ExplosionInteraction.TNT -> TerraStyleExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.RULE_TNT_EXPLOSION_DROP_DECAY);
                case Level.ExplosionInteraction.TRIGGER -> Explosion.BlockInteraction.TRIGGER_BLOCK;
            };
            TerraStyleExplosion explosion = new TerraStyleExplosion((Level)level, source, damageSource, damageCalculator, x, y, z, radius, blockInteraction);
            if (EventHooks.onExplosionStart((Level)level, (Explosion)explosion)) {
                return explosion;
            }
            explosion.explode();
            explosion.finalizeExplosion(false);
            if (!explosion.interactsWithBlocks()) {
                explosion.clearToBlow();
            }
            TerraStyleExplosionPacketS2C.send2All(level, x, y, z, radius);
            return explosion;
        }
        return level.explode(source, damageSource, damageCalculator, x, y, z, radius * 1.5f, false, explosionInteraction);
    }

    private static Explosion.BlockInteraction getDestroyType(ServerLevel level, GameRules.Key<GameRules.BooleanValue> gameRule) {
        return level.getGameRules().getBoolean(gameRule) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }
}

