/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import me.desht.pneumaticcraft.api.client.ITickableWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPneumaticCraftScreen
extends Screen {
    public int guiLeft;
    public int guiTop;
    public int xSize;
    public int ySize;

    public AbstractPneumaticCraftScreen(Component title) {
        super(title);
    }

    public void init() {
        super.init();
        this.guiLeft = this.width / 2 - this.xSize / 2;
        this.guiTop = this.height / 2 - this.ySize / 2;
    }

    @Nullable
    protected abstract ResourceLocation getGuiTexture();

    protected WidgetLabel addLabel(Component text, int x, int y) {
        return this.addLabel(text, x, y, WidgetLabel.Alignment.LEFT);
    }

    protected WidgetLabel addLabel(Component text, int x, int y, WidgetLabel.Alignment alignment) {
        return (WidgetLabel)this.addRenderableWidget((GuiEventListener)new WidgetLabel(x, y, text).setAlignment(alignment));
    }

    public void tick() {
        super.tick();
        this.renderables.stream().filter(w -> w instanceof ITickableWidget).forEach(w -> ((ITickableWidget)w).tickWidget());
    }

    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        super.render(graphics, x, y, partialTicks);
        this.drawForeground(graphics, x, y, partialTicks);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(graphics);
        if (this.getGuiTexture() != null) {
            graphics.blit(this.getGuiTexture(), this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        }
    }

    protected void drawForeground(GuiGraphics graphics, int x, int y, float partialTicks) {
    }
}

