/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneCondition;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class ProgWidgetDroneConditionEnergy
extends ProgWidgetDroneCondition {
    public static final MapCodec<ProgWidgetDroneConditionEnergy> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetDroneConditionEnergy.droneConditionParts(builder).apply((Applicative)builder, ProgWidgetDroneConditionEnergy::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetDroneConditionEnergy> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetDroneCondition.DroneConditionFields.STREAM_CODEC, ProgWidgetDroneCondition::droneConditionFields, ProgWidgetDroneConditionEnergy::new);

    public ProgWidgetDroneConditionEnergy() {
    }

    public ProgWidgetDroneConditionEnergy(ProgWidget.PositionFields pos, ProgWidgetDroneCondition.DroneConditionFields cond) {
        super(pos, cond);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetDroneConditionEnergy(this.getPosition(), this.droneConditionFields());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_DRONE_RF;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected int getCount(IDrone drone, IProgWidget widget) {
        int energy = drone.getEnergyStorage().getEnergyStored();
        this.maybeRecordMeasuredVal(drone, energy);
        return energy;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.DRONE_CONDITION_RF.get();
    }
}

