/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.CodecUtil;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public abstract class ProgWidgetInventoryBase
extends ProgWidgetAreaItemBase
implements ISidedWidget,
ICountWidget {
    protected InvBaseFields invBaseFields;

    protected static <P extends ProgWidgetInventoryBase> Products.P2<RecordCodecBuilder.Mu<P>, ProgWidget.PositionFields, InvBaseFields> invParts(RecordCodecBuilder.Instance<P> pInstance) {
        return ProgWidgetInventoryBase.baseParts(pInstance).and((App)InvBaseFields.CODEC.fieldOf("inv").forGetter(p -> p.invBaseFields));
    }

    protected ProgWidgetInventoryBase(ProgWidget.PositionFields pos, InvBaseFields invBaseFields) {
        super(pos);
        this.invBaseFields = invBaseFields;
    }

    public BitSet getAccessingSides() {
        return this.invBaseFields.accessingSides;
    }

    public InvBaseFields invBaseFields() {
        return this.invBaseFields;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getAccessingSides().isEmpty()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.noSideActive", new Object[0]));
        }
    }

    @Override
    public void setSides(boolean[] sides) {
        this.invBaseFields = this.invBaseFields.withSides(BitSet.valueOf(new byte[]{ProgWidgetInventoryBase.encodeSides(sides)}));
    }

    @Override
    public boolean[] getSides() {
        if (this.getAccessingSides().isEmpty()) {
            return new boolean[6];
        }
        return ProgWidgetInventoryBase.decodeSides(this.getAccessingSides().toByteArray()[0]);
    }

    @Override
    public boolean useCount() {
        return this.invBaseFields.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.invBaseFields = this.invBaseFields.withUseCount(useCount);
    }

    @Override
    public int getCount() {
        return this.invBaseFields.count;
    }

    @Override
    public void setCount(int count) {
        this.invBaseFields = this.invBaseFields.withCount(count);
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.isUsingSides()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.inventory.accessingSides", new Object[0]));
            curTooltip.add((Component)Component.literal((String)"\u25b6 ").append(this.getExtraStringInfo().getFirst()));
        }
        if (this.useCount()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.inventory.usingCount", this.getCount()));
        }
    }

    protected boolean isUsingSides() {
        return true;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        if (this.getAccessingSides().cardinality() == 6) {
            return List.of(ALL_TEXT);
        }
        if (this.getAccessingSides().isEmpty()) {
            return List.of(NONE_TEXT);
        }
        List<String> l = Arrays.stream(DirectionUtil.VALUES).filter(side -> this.getAccessingSides().get(side.get3DDataValue())).map(ClientUtils::translateDirection).toList();
        return List.of(Component.literal((String)Strings.join(l, (String)", ")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean baseEquals(ProgWidget other) {
        if (!super.baseEquals(other)) return false;
        if (!(other instanceof ProgWidgetInventoryBase)) return false;
        ProgWidgetInventoryBase b = (ProgWidgetInventoryBase)other;
        if (!this.invBaseFields.equals(b.invBaseFields)) return false;
        return true;
    }

    @Override
    protected int baseHashCode() {
        return Objects.hash(this.positionFields, this.invBaseFields);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetInventoryBase that = (ProgWidgetInventoryBase)o;
        return this.baseEquals(that);
    }

    @Override
    public int hashCode() {
        return this.baseHashCode();
    }

    public record InvBaseFields(BitSet accessingSides, boolean useCount, int count) {
        private static final BitSet DEFAULT_SIDES = (BitSet)Util.make((Object)new BitSet(6), bs -> bs.set(Direction.UP.get3DDataValue()));
        public static final InvBaseFields DEFAULT = new InvBaseFields(DEFAULT_SIDES, false, 1);
        public static final Codec<InvBaseFields> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtil.bitSetCodec(6).optionalFieldOf("sides", (Object)DEFAULT_SIDES).forGetter(InvBaseFields::accessingSides), (App)Codec.BOOL.optionalFieldOf("use_count", (Object)false).forGetter(InvBaseFields::useCount), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(InvBaseFields::count)).apply((Applicative)builder, InvBaseFields::new));
        public static final StreamCodec<FriendlyByteBuf, InvBaseFields> STREAM_CODEC = StreamCodec.composite(CodecUtil.bitSetStreamCodec(6), InvBaseFields::accessingSides, (StreamCodec)ByteBufCodecs.BOOL, InvBaseFields::useCount, (StreamCodec)ByteBufCodecs.VAR_INT, InvBaseFields::count, InvBaseFields::new);

        public InvBaseFields withSides(BitSet accessingSides) {
            return new InvBaseFields(accessingSides, this.useCount, this.count);
        }

        public InvBaseFields withUseCount(boolean useCount) {
            return new InvBaseFields(this.accessingSides, useCount, this.count);
        }

        public InvBaseFields withCount(int count) {
            return new InvBaseFields(this.accessingSides, this.useCount, count);
        }

        public InvBaseFields copy() {
            return new InvBaseFields(BitSet.valueOf(this.accessingSides.toByteArray()), this.useCount, this.count);
        }
    }
}

